// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Improve search recall by spell-correcting individual search query terms.
 */
public final class QuerySpellerType extends ExpandableStringEnum<QuerySpellerType> {
    /**
     * Speller not enabled.
     */
    @Generated
    public static final QuerySpellerType NONE = fromString("none");

    /**
     * Speller corrects individual query terms using a static lexicon for the language specified by the queryLanguage
     * parameter.
     */
    @Generated
    public static final QuerySpellerType LEXICON = fromString("lexicon");

    /**
     * Creates a new instance of QuerySpellerType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public QuerySpellerType() {
    }

    /**
     * Creates or finds a QuerySpellerType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding QuerySpellerType.
     */
    @Generated
    public static QuerySpellerType fromString(String name) {
        return fromString(name, QuerySpellerType.class);
    }

    /**
     * Gets known QuerySpellerType values.
     * 
     * @return known QuerySpellerType values.
     */
    @Generated
    public static Collection<QuerySpellerType> values() {
        return values(QuerySpellerType.class);
    }
}
