// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

/**
 * Specifies the syntax of the search query. The default is 'simple'. Use 'full' if your query uses the Lucene query
 * syntax and 'semantic' if query syntax is not needed.
 */
public enum QueryType {
    /**
     * Uses the simple query syntax for searches. Search text is interpreted using a simple query language that allows
     * for symbols such as +, * and "". Queries are evaluated across all searchable fields by default, unless the
     * searchFields parameter is specified.
     */
    SIMPLE("simple"),

    /**
     * Uses the full Lucene query syntax for searches. Search text is interpreted using the Lucene query language which
     * allows field-specific and weighted searches, as well as other advanced features.
     */
    FULL("full"),

    /**
     * Best suited for queries expressed in natural language as opposed to keywords. Improves precision of search
     * results by re-ranking the top search results using a ranking model trained on the Web corpus.
     */
    SEMANTIC("semantic");

    /**
     * The actual serialized value for a QueryType instance.
     */
    private final String value;

    QueryType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a QueryType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed QueryType object, or null if unable to parse.
     */
    public static QueryType fromString(String value) {
        if (value == null) {
            return null;
        }
        QueryType[] items = QueryType.values();
        for (QueryType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
