// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Reason that a partial response was returned for a semantic ranking request.
 */
public final class SemanticErrorReason extends ExpandableStringEnum<SemanticErrorReason> {
    /**
     * If `semanticMaxWaitInMilliseconds` was set and the semantic processing duration exceeded that value. Only the
     * base results were returned.
     */
    @Generated
    public static final SemanticErrorReason MAX_WAIT_EXCEEDED = fromString("maxWaitExceeded");

    /**
     * The request was throttled. Only the base results were returned.
     */
    @Generated
    public static final SemanticErrorReason CAPACITY_OVERLOADED = fromString("capacityOverloaded");

    /**
     * At least one step of the semantic process failed.
     */
    @Generated
    public static final SemanticErrorReason TRANSIENT = fromString("transient");

    /**
     * Creates a new instance of SemanticErrorReason value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public SemanticErrorReason() {
    }

    /**
     * Creates or finds a SemanticErrorReason from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SemanticErrorReason.
     */
    @Generated
    public static SemanticErrorReason fromString(String name) {
        return fromString(name, SemanticErrorReason.class);
    }

    /**
     * Gets known SemanticErrorReason values.
     * 
     * @return known SemanticErrorReason values.
     */
    @Generated
    public static Collection<SemanticErrorReason> values() {
        return values(SemanticErrorReason.class);
    }
}
