// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A single vector field result. Both &#064;search.score and vector similarity values are returned. Vector similarity is
 * related to &#064;search.score by an equation.
 */
@Immutable
public final class SingleVectorFieldResult implements JsonSerializable<SingleVectorFieldResult> {
    /*
     * The @search.score value that is calculated from the vector similarity score. This is the score that's visible in
     * a pure single-field single-vector query.
     */
    @Generated
    private Double searchScore;

    /*
     * The vector similarity score for this document. Note this is the canonical definition of similarity metric, not
     * the 'distance' version. For example, cosine similarity instead of cosine distance.
     */
    @Generated
    private Double vectorSimilarity;

    /**
     * Creates an instance of SingleVectorFieldResult class.
     */
    @Generated
    public SingleVectorFieldResult() {
    }

    /**
     * Get the searchScore property: The &#064;search.score value that is calculated from the vector similarity score.
     * This is the score that's visible in a pure single-field single-vector query.
     * 
     * @return the searchScore value.
     */
    @Generated
    public Double getSearchScore() {
        return this.searchScore;
    }

    /**
     * Get the vectorSimilarity property: The vector similarity score for this document. Note this is the canonical
     * definition of similarity metric, not the 'distance' version. For example, cosine similarity instead of cosine
     * distance.
     * 
     * @return the vectorSimilarity value.
     */
    @Generated
    public Double getVectorSimilarity() {
        return this.vectorSimilarity;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SingleVectorFieldResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SingleVectorFieldResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SingleVectorFieldResult.
     */
    @Generated
    public static SingleVectorFieldResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SingleVectorFieldResult deserializedSingleVectorFieldResult = new SingleVectorFieldResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("searchScore".equals(fieldName)) {
                    deserializedSingleVectorFieldResult.searchScore = reader.getNullable(JsonReader::getDouble);
                } else if ("vectorSimilarity".equals(fieldName)) {
                    deserializedSingleVectorFieldResult.vectorSimilarity = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSingleVectorFieldResult;
        });
    }
}
