// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The query parameters for vector and hybrid search queries.
 */
@Fluent
public class VectorQuery implements JsonSerializable<VectorQuery> {

    /*
     * The kind of vector query being performed.
     */
    @Generated
    private VectorQueryKind kind = VectorQueryKind.fromString("VectorQuery");

    /*
     * Number of nearest neighbors to return as top hits.
     */
    @Generated
    private Integer kNearestNeighborsCount;

    /*
     * Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     */
    @Generated
    private String fields;

    /*
     * When true, triggers an exhaustive k-nearest neighbor search across all vectors within the vector index. Useful
     * for scenarios where exact matches are critical, such as determining ground truth values.
     */
    @Generated
    private Boolean exhaustive;

    /*
     * Oversampling factor. Minimum value is 1. It overrides the 'defaultOversampling' parameter configured in the index
     * definition. It can be set only when 'rerankWithOriginalVectors' is true. This parameter is only permitted when a
     * compression method is used on the underlying vector field.
     */
    @Generated
    private Double oversampling;

    /*
     * Relative weight of the vector query when compared to other vector query and/or the text query within the same
     * search request. This value is used when combining the results of multiple ranking lists produced by the different
     * vector queries and/or the results retrieved through the text query. The higher the weight, the higher the
     * documents that matched that query will be in the final ranking. Default is 1.0 and the value needs to be a
     * positive number larger than zero.
     */
    @Generated
    private Float weight;

    /*
     * The threshold used for vector queries. Note this can only be set if all 'fields' use the same similarity metric.
     */
    @Generated
    private VectorThreshold threshold;

    /*
     * The OData filter expression to apply to this specific vector query. If no filter expression is defined at the
     * vector level, the expression defined in the top level filter parameter is used instead.
     */
    @Generated
    private String filterOverride;

    /*
     * Controls how many vectors can be matched from each document in a vector search query. Setting it to 1 ensures at
     * most one vector per document is matched, guaranteeing results come from distinct documents. Setting it to 0
     * (unlimited) allows multiple relevant vectors from the same document to be matched. Default is 0.
     */
    @Generated
    private Integer perDocumentVectorLimit;

    /**
     * Creates an instance of VectorQuery class.
     */
    @Generated
    public VectorQuery() {
    }

    /**
     * Get the kind property: The kind of vector query being performed.
     *
     * @return the kind value.
     */
    @Generated
    public VectorQueryKind getKind() {
        return this.kind;
    }

    /**
     * Get the kNearestNeighborsCount property: Number of nearest neighbors to return as top hits.
     *
     * @return the kNearestNeighborsCount value.
     */
    @Generated
    public Integer getKNearestNeighborsCount() {
        return this.kNearestNeighborsCount;
    }

    /**
     * Set the kNearestNeighborsCount property: Number of nearest neighbors to return as top hits.
     *
     * @param kNearestNeighborsCount the kNearestNeighborsCount value to set.
     * @return the VectorQuery object itself.
     */
    @Generated
    public VectorQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        this.kNearestNeighborsCount = kNearestNeighborsCount;
        return this;
    }

    /**
     * Get the fields property: Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     *
     * @return the fields value.
     */
    @Generated
    public String getFields() {
        return this.fields;
    }

    /**
     * Set the fields property: Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     *
     * @param fields the fields value to set.
     * @return the VectorQuery object itself.
     */
    @Generated
    public VectorQuery setFields(String... fields) {
        this.fields = (fields == null) ? null : String.join(",", fields);
        return this;
    }

    /**
     * Get the exhaustive property: When true, triggers an exhaustive k-nearest neighbor search across all vectors
     * within the vector index. Useful for scenarios where exact matches are critical, such as determining ground truth
     * values.
     *
     * @return the exhaustive value.
     */
    @Generated
    public Boolean isExhaustive() {
        return this.exhaustive;
    }

    /**
     * Set the exhaustive property: When true, triggers an exhaustive k-nearest neighbor search across all vectors
     * within the vector index. Useful for scenarios where exact matches are critical, such as determining ground truth
     * values.
     *
     * @param exhaustive the exhaustive value to set.
     * @return the VectorQuery object itself.
     */
    @Generated
    public VectorQuery setExhaustive(Boolean exhaustive) {
        this.exhaustive = exhaustive;
        return this;
    }

    /**
     * Get the oversampling property: Oversampling factor. Minimum value is 1. It overrides the 'defaultOversampling'
     * parameter configured in the index definition. It can be set only when 'rerankWithOriginalVectors' is true. This
     * parameter is only permitted when a compression method is used on the underlying vector field.
     *
     * @return the oversampling value.
     */
    @Generated
    public Double getOversampling() {
        return this.oversampling;
    }

    /**
     * Set the oversampling property: Oversampling factor. Minimum value is 1. It overrides the 'defaultOversampling'
     * parameter configured in the index definition. It can be set only when 'rerankWithOriginalVectors' is true. This
     * parameter is only permitted when a compression method is used on the underlying vector field.
     *
     * @param oversampling the oversampling value to set.
     * @return the VectorQuery object itself.
     */
    @Generated
    public VectorQuery setOversampling(Double oversampling) {
        this.oversampling = oversampling;
        return this;
    }

    /**
     * Get the weight property: Relative weight of the vector query when compared to other vector query and/or the text
     * query within the same search request. This value is used when combining the results of multiple ranking lists
     * produced by the different vector queries and/or the results retrieved through the text query. The higher the
     * weight, the higher the documents that matched that query will be in the final ranking. Default is 1.0 and the
     * value needs to be a positive number larger than zero.
     *
     * @return the weight value.
     */
    @Generated
    public Float getWeight() {
        return this.weight;
    }

    /**
     * Set the weight property: Relative weight of the vector query when compared to other vector query and/or the text
     * query within the same search request. This value is used when combining the results of multiple ranking lists
     * produced by the different vector queries and/or the results retrieved through the text query. The higher the
     * weight, the higher the documents that matched that query will be in the final ranking. Default is 1.0 and the
     * value needs to be a positive number larger than zero.
     *
     * @param weight the weight value to set.
     * @return the VectorQuery object itself.
     */
    @Generated
    public VectorQuery setWeight(Float weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Get the threshold property: The threshold used for vector queries. Note this can only be set if all 'fields' use
     * the same similarity metric.
     *
     * @return the threshold value.
     */
    @Generated
    public VectorThreshold getThreshold() {
        return this.threshold;
    }

    /**
     * Set the threshold property: The threshold used for vector queries. Note this can only be set if all 'fields' use
     * the same similarity metric.
     *
     * @param threshold the threshold value to set.
     * @return the VectorQuery object itself.
     */
    @Generated
    public VectorQuery setThreshold(VectorThreshold threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Get the filterOverride property: The OData filter expression to apply to this specific vector query. If no filter
     * expression is defined at the vector level, the expression defined in the top level filter parameter is used
     * instead.
     *
     * @return the filterOverride value.
     */
    @Generated
    public String getFilterOverride() {
        return this.filterOverride;
    }

    /**
     * Set the filterOverride property: The OData filter expression to apply to this specific vector query. If no filter
     * expression is defined at the vector level, the expression defined in the top level filter parameter is used
     * instead.
     *
     * @param filterOverride the filterOverride value to set.
     * @return the VectorQuery object itself.
     */
    @Generated
    public VectorQuery setFilterOverride(String filterOverride) {
        this.filterOverride = filterOverride;
        return this;
    }

    /**
     * Get the perDocumentVectorLimit property: Controls how many vectors can be matched from each document in a vector
     * search query. Setting it to 1 ensures at most one vector per document is matched, guaranteeing results come from
     * distinct documents. Setting it to 0 (unlimited) allows multiple relevant vectors from the same document to be
     * matched. Default is 0.
     *
     * @return the perDocumentVectorLimit value.
     */
    @Generated
    public Integer getPerDocumentVectorLimit() {
        return this.perDocumentVectorLimit;
    }

    /**
     * Set the perDocumentVectorLimit property: Controls how many vectors can be matched from each document in a vector
     * search query. Setting it to 1 ensures at most one vector per document is matched, guaranteeing results come from
     * distinct documents. Setting it to 0 (unlimited) allows multiple relevant vectors from the same document to be
     * matched. Default is 0.
     *
     * @param perDocumentVectorLimit the perDocumentVectorLimit value to set.
     * @return the VectorQuery object itself.
     */
    @Generated
    public VectorQuery setPerDocumentVectorLimit(Integer perDocumentVectorLimit) {
        this.perDocumentVectorLimit = perDocumentVectorLimit;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("k", this.kNearestNeighborsCount);
        jsonWriter.writeStringField("fields", this.fields);
        jsonWriter.writeBooleanField("exhaustive", this.exhaustive);
        jsonWriter.writeNumberField("oversampling", this.oversampling);
        jsonWriter.writeNumberField("weight", this.weight);
        jsonWriter.writeJsonField("threshold", this.threshold);
        jsonWriter.writeStringField("filterOverride", this.filterOverride);
        jsonWriter.writeNumberField("perDocumentVectorLimit", this.perDocumentVectorLimit);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorQuery from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorQuery if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorQuery.
     */
    @Generated
    public static VectorQuery fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("text".equals(discriminatorValue)) {
                    return VectorizableTextQuery.fromJson(readerToUse.reset());
                } else if ("imageUrl".equals(discriminatorValue)) {
                    return VectorizableImageUrlQuery.fromJson(readerToUse.reset());
                } else if ("imageBinary".equals(discriminatorValue)) {
                    return VectorizableImageBinaryQuery.fromJson(readerToUse.reset());
                } else if ("vector".equals(discriminatorValue)) {
                    return VectorizedQuery.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static VectorQuery fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorQuery deserializedVectorQuery = new VectorQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedVectorQuery.kind = VectorQueryKind.fromString(reader.getString());
                } else if ("k".equals(fieldName)) {
                    deserializedVectorQuery.kNearestNeighborsCount = reader.getNullable(JsonReader::getInt);
                } else if ("fields".equals(fieldName)) {
                    deserializedVectorQuery.fields = reader.getString();
                } else if ("exhaustive".equals(fieldName)) {
                    deserializedVectorQuery.exhaustive = reader.getNullable(JsonReader::getBoolean);
                } else if ("oversampling".equals(fieldName)) {
                    deserializedVectorQuery.oversampling = reader.getNullable(JsonReader::getDouble);
                } else if ("weight".equals(fieldName)) {
                    deserializedVectorQuery.weight = reader.getNullable(JsonReader::getFloat);
                } else if ("threshold".equals(fieldName)) {
                    deserializedVectorQuery.threshold = VectorThreshold.fromJson(reader);
                } else if ("filterOverride".equals(fieldName)) {
                    deserializedVectorQuery.filterOverride = reader.getString();
                } else if ("perDocumentVectorLimit".equals(fieldName)) {
                    deserializedVectorQuery.perDocumentVectorLimit = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedVectorQuery;
        });
    }
}
