// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The threshold used for vector queries.
 */
@Immutable
public class VectorThreshold implements JsonSerializable<VectorThreshold> {
    /*
     * The kind of threshold used to filter vector queries
     */
    @Generated
    private VectorThresholdKind kind = VectorThresholdKind.fromString("VectorThreshold");

    /**
     * Creates an instance of VectorThreshold class.
     */
    @Generated
    public VectorThreshold() {
    }

    /**
     * Get the kind property: The kind of threshold used to filter vector queries.
     * 
     * @return the kind value.
     */
    @Generated
    public VectorThresholdKind getKind() {
        return this.kind;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorThreshold from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorThreshold if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorThreshold.
     */
    @Generated
    public static VectorThreshold fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("vectorSimilarity".equals(discriminatorValue)) {
                    return VectorSimilarityThreshold.fromJson(readerToUse.reset());
                } else if ("searchScore".equals(discriminatorValue)) {
                    return SearchScoreThreshold.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static VectorThreshold fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorThreshold deserializedVectorThreshold = new VectorThreshold();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedVectorThreshold.kind = VectorThresholdKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVectorThreshold;
        });
    }
}
