// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The query parameters to use for vector search when an url that represents an image value that needs to be vectorized
 * is provided.
 */
@Fluent
public final class VectorizableImageUrlQuery extends VectorQuery {

    /*
     * The kind of vector query being performed.
     */
    @Generated
    private VectorQueryKind kind = VectorQueryKind.IMAGE_URL;

    /*
     * The URL of an image to be vectorized to perform a vector search query.
     */
    @Generated
    private String url;

    /**
     * Creates an instance of VectorizableImageUrlQuery class.
     */
    @Generated
    public VectorizableImageUrlQuery() {
    }

    /**
     * Get the kind property: The kind of vector query being performed.
     *
     * @return the kind value.
     */
    @Generated
    @Override
    public VectorQueryKind getKind() {
        return this.kind;
    }

    /**
     * Get the url property: The URL of an image to be vectorized to perform a vector search query.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Set the url property: The URL of an image to be vectorized to perform a vector search query.
     *
     * @param url the url value to set.
     * @return the VectorizableImageUrlQuery object itself.
     */
    @Generated
    public VectorizableImageUrlQuery setUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageUrlQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        super.setKNearestNeighborsCount(kNearestNeighborsCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageUrlQuery setFields(String... fields) {
        super.setFields(fields);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageUrlQuery setExhaustive(Boolean exhaustive) {
        super.setExhaustive(exhaustive);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageUrlQuery setOversampling(Double oversampling) {
        super.setOversampling(oversampling);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageUrlQuery setWeight(Float weight) {
        super.setWeight(weight);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageUrlQuery setThreshold(VectorThreshold threshold) {
        super.setThreshold(threshold);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageUrlQuery setFilterOverride(String filterOverride) {
        super.setFilterOverride(filterOverride);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageUrlQuery setPerDocumentVectorLimit(Integer perDocumentVectorLimit) {
        super.setPerDocumentVectorLimit(perDocumentVectorLimit);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("k", getKNearestNeighborsCount());
        jsonWriter.writeStringField("fields", getFields());
        jsonWriter.writeBooleanField("exhaustive", isExhaustive());
        jsonWriter.writeNumberField("oversampling", getOversampling());
        jsonWriter.writeNumberField("weight", getWeight());
        jsonWriter.writeJsonField("threshold", getThreshold());
        jsonWriter.writeStringField("filterOverride", getFilterOverride());
        jsonWriter.writeNumberField("perDocumentVectorLimit", getPerDocumentVectorLimit());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorizableImageUrlQuery from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorizableImageUrlQuery if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorizableImageUrlQuery.
     */
    @Generated
    public static VectorizableImageUrlQuery fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorizableImageUrlQuery deserializedVectorizableImageUrlQuery = new VectorizableImageUrlQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("k".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery
                        .setKNearestNeighborsCount(reader.getNullable(JsonReader::getInt));
                } else if ("fields".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setFields(reader.getString());
                } else if ("exhaustive".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setExhaustive(reader.getNullable(JsonReader::getBoolean));
                } else if ("oversampling".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setOversampling(reader.getNullable(JsonReader::getDouble));
                } else if ("weight".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setWeight(reader.getNullable(JsonReader::getFloat));
                } else if ("threshold".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setThreshold(VectorThreshold.fromJson(reader));
                } else if ("filterOverride".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.setFilterOverride(reader.getString());
                } else if ("perDocumentVectorLimit".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery
                        .setPerDocumentVectorLimit(reader.getNullable(JsonReader::getInt));
                } else if ("kind".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.kind = VectorQueryKind.fromString(reader.getString());
                } else if ("url".equals(fieldName)) {
                    deserializedVectorizableImageUrlQuery.url = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedVectorizableImageUrlQuery;
        });
    }
}
