// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

/** Groups the settings used for formatting the response if the response should be Arrow formatted. */
@JacksonXmlRootElement(localName = "ArrowConfiguration")
@Fluent
public final class ArrowConfiguration {
    private static final class SchemaWrapper {
        @JacksonXmlProperty(localName = "Field")
        private final List<ArrowField> items;

        @JsonCreator
        private SchemaWrapper(@JacksonXmlProperty(localName = "Field") List<ArrowField> items) {
            this.items = items;
        }
    }

    /*
     * The Schema property.
     */
    @JsonProperty(value = "Schema", required = true)
    private SchemaWrapper schema;

    /**
     * Get the schema property: The Schema property.
     *
     * @return the schema value.
     */
    public List<ArrowField> getSchema() {
        if (this.schema == null) {
            this.schema = new SchemaWrapper(new ArrayList<ArrowField>());
        }
        return this.schema.items;
    }

    /**
     * Set the schema property: The Schema property.
     *
     * @param schema the schema value to set.
     * @return the ArrowConfiguration object itself.
     */
    public ArrowConfiguration setSchema(List<ArrowField> schema) {
        this.schema = new SchemaWrapper(schema);
        return this;
    }
}
