// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaders;
import com.azure.storage.blob.implementation.accesshelpers.BlobQueryHeadersConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobsQueryHeaders;

import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Defines headers for Query operation.
 */
@Fluent
public final class BlobQueryHeaders {
    private final BlobsQueryHeaders internalHeaders;

    static {
        BlobQueryHeadersConstructorProxy.setAccessor(BlobQueryHeaders::new);
    }

    /*
     * The errorCode property.
     */
    private String errorCode;

    private BlobQueryHeaders(BlobsQueryHeaders internalHeaders) {
        this.internalHeaders = internalHeaders;
    }

    /**
     * Constructs a new instance of {@link BlobQueryHeaders}.
     */
    public BlobQueryHeaders() {
        // Added to maintain backwards compatibility as the private constructor removes the implicit no args constructor
        this.internalHeaders = new BlobsQueryHeaders(new HttpHeaders());
    }

    /**
     * Get the lastModified property: Returns the date and time the container
     * was last modified. Any operation that modifies the blob, including an
     * update of the blob's metadata or properties, changes the last-modified
     * time of the blob.
     *
     * @return the lastModified value.
     */
    public OffsetDateTime getLastModified() {
        return internalHeaders.getLastModified();
    }

    /**
     * Set the lastModified property: Returns the date and time the container
     * was last modified. Any operation that modifies the blob, including an
     * update of the blob's metadata or properties, changes the last-modified
     * time of the blob.
     *
     * @param lastModified the lastModified value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setLastModified(OffsetDateTime lastModified) {
        internalHeaders.setLastModified(lastModified);
        return this;
    }

    /**
     * Get the metadata property: The metadata property.
     *
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return internalHeaders.getXMsMeta();
    }

    /**
     * Set the metadata property: The metadata property.
     *
     * @param metadata the metadata value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setMetadata(Map<String, String> metadata) {
        internalHeaders.setXMsMeta(metadata);
        return this;
    }

    /**
     * Get the contentLength property: The number of bytes present in the
     * response body.
     *
     * @return the contentLength value.
     */
    public Long getContentLength() {
        return internalHeaders.getContentLength();
    }

    /**
     * Set the contentLength property: The number of bytes present in the
     * response body.
     *
     * @param contentLength the contentLength value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setContentLength(Long contentLength) {
        internalHeaders.setContentLength(contentLength);
        return this;
    }

    /**
     * Get the contentType property: The media type of the body of the
     * response. For Download Blob this is 'application/octet-stream'.
     *
     * @return the contentType value.
     */
    public String getContentType() {
        return internalHeaders.getContentType();
    }

    /**
     * Set the contentType property: The media type of the body of the
     * response. For Download Blob this is 'application/octet-stream'.
     *
     * @param contentType the contentType value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setContentType(String contentType) {
        internalHeaders.setContentType(contentType);
        return this;
    }

    /**
     * Get the contentRange property: Indicates the range of bytes returned in
     * the event that the client requested a subset of the blob by setting the
     * 'Range' request header.
     *
     * @return the contentRange value.
     */
    public String getContentRange() {
        return internalHeaders.getContentRange();
    }

    /**
     * Set the contentRange property: Indicates the range of bytes returned in
     * the event that the client requested a subset of the blob by setting the
     * 'Range' request header.
     *
     * @param contentRange the contentRange value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setContentRange(String contentRange) {
        internalHeaders.setContentRange(contentRange);
        return this;
    }

    /**
     * Get the eTag property: The ETag contains a value that you can use to
     * perform operations conditionally. If the request version is 2011-08-18
     * or newer, the ETag value will be in quotes.
     *
     * @return the eTag value.
     */
    public String getETag() {
        return internalHeaders.getETag();
    }

    /**
     * Set the eTag property: The ETag contains a value that you can use to
     * perform operations conditionally. If the request version is 2011-08-18
     * or newer, the ETag value will be in quotes.
     *
     * @param eTag the eTag value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setETag(String eTag) {
        internalHeaders.setETag(eTag);
        return this;
    }

    /**
     * Get the contentMd5 property: If the blob has an MD5 hash and this
     * operation is to read the full blob, this response header is returned so
     * that the client can check for message content integrity.
     *
     * @return the contentMd5 value.
     */
    public byte[] getContentMd5() {
        return internalHeaders.getContentMD5();
    }

    /**
     * Set the contentMd5 property: If the blob has an MD5 hash and this
     * operation is to read the full blob, this response header is returned so
     * that the client can check for message content integrity.
     *
     * @param contentMd5 the contentMd5 value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setContentMd5(byte[] contentMd5) {
        internalHeaders.setContentMD5(contentMd5);
        return this;
    }

    /**
     * Get the contentEncoding property: This header returns the value that was
     * specified for the Content-Encoding request header.
     *
     * @return the contentEncoding value.
     */
    public String getContentEncoding() {
        return internalHeaders.getContentEncoding();
    }

    /**
     * Set the contentEncoding property: This header returns the value that was
     * specified for the Content-Encoding request header.
     *
     * @param contentEncoding the contentEncoding value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setContentEncoding(String contentEncoding) {
        internalHeaders.setContentEncoding(contentEncoding);
        return this;
    }

    /**
     * Get the cacheControl property: This header is returned if it was
     * previously specified for the blob.
     *
     * @return the cacheControl value.
     */
    public String getCacheControl() {
        return internalHeaders.getCacheControl();
    }

    /**
     * Set the cacheControl property: This header is returned if it was
     * previously specified for the blob.
     *
     * @param cacheControl the cacheControl value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setCacheControl(String cacheControl) {
        internalHeaders.setCacheControl(cacheControl);
        return this;
    }

    /**
     * Get the contentDisposition property: This header returns the value that
     * was specified for the 'x-ms-blob-content-disposition' header. The
     * Content-Disposition response header field conveys additional information
     * about how to process the response payload, and also can be used to
     * attach additional metadata. For example, if set to attachment, it
     * indicates that the user-agent should not display the response, but
     * instead show a Save As dialog with a filename other than the blob name
     * specified.
     *
     * @return the contentDisposition value.
     */
    public String getContentDisposition() {
        return internalHeaders.getContentDisposition();
    }

    /**
     * Set the contentDisposition property: This header returns the value that
     * was specified for the 'x-ms-blob-content-disposition' header. The
     * Content-Disposition response header field conveys additional information
     * about how to process the response payload, and also can be used to
     * attach additional metadata. For example, if set to attachment, it
     * indicates that the user-agent should not display the response, but
     * instead show a Save As dialog with a filename other than the blob name
     * specified.
     *
     * @param contentDisposition the contentDisposition value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setContentDisposition(String contentDisposition) {
        internalHeaders.setContentDisposition(contentDisposition);
        return this;
    }

    /**
     * Get the contentLanguage property: This header returns the value that was
     * specified for the Content-Language request header.
     *
     * @return the contentLanguage value.
     */
    public String getContentLanguage() {
        return internalHeaders.getContentLanguage();
    }

    /**
     * Set the contentLanguage property: This header returns the value that was
     * specified for the Content-Language request header.
     *
     * @param contentLanguage the contentLanguage value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setContentLanguage(String contentLanguage) {
        internalHeaders.setContentLanguage(contentLanguage);
        return this;
    }

    /**
     * Get the blobSequenceNumber property: The current sequence number for a
     * page blob. This header is not returned for block blobs or append blobs.
     *
     * @return the blobSequenceNumber value.
     */
    public Long getBlobSequenceNumber() {
        return internalHeaders.getXMsBlobSequenceNumber();
    }

    /**
     * Set the blobSequenceNumber property: The current sequence number for a
     * page blob. This header is not returned for block blobs or append blobs.
     *
     * @param blobSequenceNumber the blobSequenceNumber value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setBlobSequenceNumber(Long blobSequenceNumber) {
        internalHeaders.setXMsBlobSequenceNumber(blobSequenceNumber);
        return this;
    }

    /**
     * Get the blobType property: The blob's type. Possible values include:
     * 'BlockBlob', 'PageBlob', 'AppendBlob'.
     *
     * @return the blobType value.
     */
    public BlobType getBlobType() {
        return internalHeaders.getXMsBlobType();
    }

    /**
     * Set the blobType property: The blob's type. Possible values include:
     * 'BlockBlob', 'PageBlob', 'AppendBlob'.
     *
     * @param blobType the blobType value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setBlobType(BlobType blobType) {
        internalHeaders.setXMsBlobType(blobType);
        return this;
    }

    /**
     * Get the copyCompletionTime property: Conclusion time of the last
     * attempted Copy Blob operation where this blob was the destination blob.
     * This value can specify the time of a completed, aborted, or failed copy
     * attempt. This header does not appear if a copy is pending, if this blob
     * has never been the destination in a Copy Blob operation, or if this blob
     * has been modified after a concluded Copy Blob operation using Set Blob
     * Properties, Put Blob, or Put Block List.
     *
     * @return the copyCompletionTime value.
     */
    public OffsetDateTime getCopyCompletionTime() {
        return internalHeaders.getXMsCopyCompletionTime();
    }

    /**
     * Set the copyCompletionTime property: Conclusion time of the last
     * attempted Copy Blob operation where this blob was the destination blob.
     * This value can specify the time of a completed, aborted, or failed copy
     * attempt. This header does not appear if a copy is pending, if this blob
     * has never been the destination in a Copy Blob operation, or if this blob
     * has been modified after a concluded Copy Blob operation using Set Blob
     * Properties, Put Blob, or Put Block List.
     *
     * @param copyCompletionTime the copyCompletionTime value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        internalHeaders.setXMsCopyCompletionTime(copyCompletionTime);
        return this;
    }

    /**
     * Get the copyStatusDescription property: Only appears when
     * x-ms-copy-status is failed or pending. Describes the cause of the last
     * fatal or non-fatal copy operation failure. This header does not appear
     * if this blob has never been the destination in a Copy Blob operation, or
     * if this blob has been modified after a concluded Copy Blob operation
     * using Set Blob Properties, Put Blob, or Put Block List.
     *
     * @return the copyStatusDescription value.
     */
    public String getCopyStatusDescription() {
        return internalHeaders.getXMsCopyStatusDescription();
    }

    /**
     * Set the copyStatusDescription property: Only appears when
     * x-ms-copy-status is failed or pending. Describes the cause of the last
     * fatal or non-fatal copy operation failure. This header does not appear
     * if this blob has never been the destination in a Copy Blob operation, or
     * if this blob has been modified after a concluded Copy Blob operation
     * using Set Blob Properties, Put Blob, or Put Block List.
     *
     * @param copyStatusDescription the copyStatusDescription value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setCopyStatusDescription(String copyStatusDescription) {
        internalHeaders.setXMsCopyStatusDescription(copyStatusDescription);
        return this;
    }

    /**
     * Get the copyId property: String identifier for this copy operation. Use
     * with Get Blob Properties to check the status of this copy operation, or
     * pass to Abort Copy Blob to abort a pending copy.
     *
     * @return the copyId value.
     */
    public String getCopyId() {
        return internalHeaders.getXMsCopyId();
    }

    /**
     * Set the copyId property: String identifier for this copy operation. Use
     * with Get Blob Properties to check the status of this copy operation, or
     * pass to Abort Copy Blob to abort a pending copy.
     *
     * @param copyId the copyId value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setCopyId(String copyId) {
        internalHeaders.setXMsCopyId(copyId);
        return this;
    }

    /**
     * Get the copyProgress property: Contains the number of bytes copied and
     * the total bytes in the source in the last attempted Copy Blob operation
     * where this blob was the destination blob. Can show between 0 and
     * Content-Length bytes copied. This header does not appear if this blob
     * has never been the destination in a Copy Blob operation, or if this blob
     * has been modified after a concluded Copy Blob operation using Set Blob
     * Properties, Put Blob, or Put Block List.
     *
     * @return the copyProgress value.
     */
    public String getCopyProgress() {
        return internalHeaders.getXMsCopyProgress();
    }

    /**
     * Set the copyProgress property: Contains the number of bytes copied and
     * the total bytes in the source in the last attempted Copy Blob operation
     * where this blob was the destination blob. Can show between 0 and
     * Content-Length bytes copied. This header does not appear if this blob
     * has never been the destination in a Copy Blob operation, or if this blob
     * has been modified after a concluded Copy Blob operation using Set Blob
     * Properties, Put Blob, or Put Block List.
     *
     * @param copyProgress the copyProgress value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setCopyProgress(String copyProgress) {
        internalHeaders.setXMsCopyProgress(copyProgress);
        return this;
    }

    /**
     * Get the copySource property: URL up to 2 KB in length that specifies the
     * source blob or file used in the last attempted Copy Blob operation where
     * this blob was the destination blob. This header does not appear if this
     * blob has never been the destination in a Copy Blob operation, or if this
     * blob has been modified after a concluded Copy Blob operation using Set
     * Blob Properties, Put Blob, or Put Block List.
     *
     * @return the copySource value.
     */
    public String getCopySource() {
        return internalHeaders.getXMsCopySource();
    }

    /**
     * Set the copySource property: URL up to 2 KB in length that specifies the
     * source blob or file used in the last attempted Copy Blob operation where
     * this blob was the destination blob. This header does not appear if this
     * blob has never been the destination in a Copy Blob operation, or if this
     * blob has been modified after a concluded Copy Blob operation using Set
     * Blob Properties, Put Blob, or Put Block List.
     *
     * @param copySource the copySource value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setCopySource(String copySource) {
        internalHeaders.setXMsCopySource(copySource);
        return this;
    }

    /**
     * Get the copyStatus property: State of the copy operation identified by
     * x-ms-copy-id. Possible values include: 'pending', 'success', 'aborted',
     * 'failed'.
     *
     * @return the copyStatus value.
     */
    public CopyStatusType getCopyStatus() {
        return internalHeaders.getXMsCopyStatus();
    }

    /**
     * Set the copyStatus property: State of the copy operation identified by
     * x-ms-copy-id. Possible values include: 'pending', 'success', 'aborted',
     * 'failed'.
     *
     * @param copyStatus the copyStatus value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setCopyStatus(CopyStatusType copyStatus) {
        internalHeaders.setXMsCopyStatus(copyStatus);
        return this;
    }

    /**
     * Get the leaseDuration property: When a blob is leased, specifies whether
     * the lease is of infinite or fixed duration. Possible values include:
     * 'infinite', 'fixed'.
     *
     * @return the leaseDuration value.
     */
    public LeaseDurationType getLeaseDuration() {
        return internalHeaders.getXMsLeaseDuration();
    }

    /**
     * Set the leaseDuration property: When a blob is leased, specifies whether
     * the lease is of infinite or fixed duration. Possible values include:
     * 'infinite', 'fixed'.
     *
     * @param leaseDuration the leaseDuration value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        internalHeaders.setXMsLeaseDuration(leaseDuration);
        return this;
    }

    /**
     * Get the leaseState property: Lease state of the blob. Possible values
     * include: 'available', 'leased', 'expired', 'breaking', 'broken'.
     *
     * @return the leaseState value.
     */
    public LeaseStateType getLeaseState() {
        return internalHeaders.getXMsLeaseState();
    }

    /**
     * Set the leaseState property: Lease state of the blob. Possible values
     * include: 'available', 'leased', 'expired', 'breaking', 'broken'.
     *
     * @param leaseState the leaseState value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setLeaseState(LeaseStateType leaseState) {
        internalHeaders.setXMsLeaseState(leaseState);
        return this;
    }

    /**
     * Get the leaseStatus property: The current lease status of the blob.
     * Possible values include: 'locked', 'unlocked'.
     *
     * @return the leaseStatus value.
     */
    public LeaseStatusType getLeaseStatus() {
        return internalHeaders.getXMsLeaseStatus();
    }

    /**
     * Set the leaseStatus property: The current lease status of the blob.
     * Possible values include: 'locked', 'unlocked'.
     *
     * @param leaseStatus the leaseStatus value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        internalHeaders.setXMsLeaseStatus(leaseStatus);
        return this;
    }

    /**
     * Get the clientRequestId property: If a client request id header is sent
     * in the request, this header will be present in the response with the
     * same value.
     *
     * @return the clientRequestId value.
     */
    public String getClientRequestId() {
        return internalHeaders.getXMsClientRequestId();
    }

    /**
     * Set the clientRequestId property: If a client request id header is sent
     * in the request, this header will be present in the response with the
     * same value.
     *
     * @param clientRequestId the clientRequestId value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setClientRequestId(String clientRequestId) {
        internalHeaders.setXMsClientRequestId(clientRequestId);
        return this;
    }

    /**
     * Get the requestId property: This header uniquely identifies the request
     * that was made and can be used for troubleshooting the request.
     *
     * @return the requestId value.
     */
    public String getRequestId() {
        return internalHeaders.getXMsRequestId();
    }

    /**
     * Set the requestId property: This header uniquely identifies the request
     * that was made and can be used for troubleshooting the request.
     *
     * @param requestId the requestId value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setRequestId(String requestId) {
        internalHeaders.setXMsRequestId(requestId);
        return this;
    }

    /**
     * Get the version property: Indicates the version of the Blob service used
     * to execute the request. This header is returned for requests made
     * against version 2009-09-19 and above.
     *
     * @return the version value.
     */
    public String getVersion() {
        return internalHeaders.getXMsVersion();
    }

    /**
     * Set the version property: Indicates the version of the Blob service used
     * to execute the request. This header is returned for requests made
     * against version 2009-09-19 and above.
     *
     * @param version the version value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setVersion(String version) {
        internalHeaders.setXMsVersion(version);
        return this;
    }

    /**
     * Get the acceptRanges property: Indicates that the service supports
     * requests for partial blob content.
     *
     * @return the acceptRanges value.
     */
    public String getAcceptRanges() {
        return internalHeaders.getAcceptRanges();
    }

    /**
     * Set the acceptRanges property: Indicates that the service supports
     * requests for partial blob content.
     *
     * @param acceptRanges the acceptRanges value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setAcceptRanges(String acceptRanges) {
        internalHeaders.setAcceptRanges(acceptRanges);
        return this;
    }

    /**
     * Get the dateProperty property: UTC date/time value generated by the
     * service that indicates the time at which the response was initiated.
     *
     * @return the dateProperty value.
     */
    public OffsetDateTime getDateProperty() {
        return internalHeaders.getDate();
    }

    /**
     * Set the dateProperty property: UTC date/time value generated by the
     * service that indicates the time at which the response was initiated.
     *
     * @param dateProperty the dateProperty value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setDateProperty(OffsetDateTime dateProperty) {
        internalHeaders.setDate(dateProperty);
        return this;
    }

    /**
     * Get the blobCommittedBlockCount property: The number of committed blocks
     * present in the blob. This header is returned only for append blobs.
     *
     * @return the blobCommittedBlockCount value.
     */
    public Integer getBlobCommittedBlockCount() {
        return internalHeaders.getXMsBlobCommittedBlockCount();
    }

    /**
     * Set the blobCommittedBlockCount property: The number of committed blocks
     * present in the blob. This header is returned only for append blobs.
     *
     * @param blobCommittedBlockCount the blobCommittedBlockCount value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setBlobCommittedBlockCount(Integer blobCommittedBlockCount) {
        internalHeaders.setXMsBlobCommittedBlockCount(blobCommittedBlockCount);
        return this;
    }

    /**
     * Get the serverEncrypted property: The value of this header is set to
     * true if the blob data and application metadata are completely encrypted
     * using the specified algorithm. Otherwise, the value is set to false
     * (when the blob is unencrypted, or if only parts of the blob/application
     * metadata are encrypted).
     *
     * @return the serverEncrypted value.
     */
    public Boolean isServerEncrypted() {
        return internalHeaders.isXMsServerEncrypted();
    }

    /**
     * Set the serverEncrypted property: The value of this header is set to
     * true if the blob data and application metadata are completely encrypted
     * using the specified algorithm. Otherwise, the value is set to false
     * (when the blob is unencrypted, or if only parts of the blob/application
     * metadata are encrypted).
     *
     * @param serverEncrypted the serverEncrypted value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setServerEncrypted(Boolean serverEncrypted) {
        internalHeaders.setXMsServerEncrypted(serverEncrypted);
        return this;
    }

    /**
     * Get the encryptionKeySha256 property: The SHA-256 hash of the encryption
     * key used to encrypt the blob. This header is only returned when the blob
     * was encrypted with a customer-provided key.
     *
     * @return the encryptionKeySha256 value.
     */
    public String getEncryptionKeySha256() {
        return internalHeaders.getXMsEncryptionKeySha256();
    }

    /**
     * Set the encryptionKeySha256 property: The SHA-256 hash of the encryption
     * key used to encrypt the blob. This header is only returned when the blob
     * was encrypted with a customer-provided key.
     *
     * @param encryptionKeySha256 the encryptionKeySha256 value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setEncryptionKeySha256(String encryptionKeySha256) {
        internalHeaders.setXMsEncryptionKeySha256(encryptionKeySha256);
        return this;
    }

    /**
     * Get the encryptionScope property: Returns the name of the encryption
     * scope used to encrypt the blob contents and application metadata.  Note
     * that the absence of this header implies use of the default account
     * encryption scope.
     *
     * @return the encryptionScope value.
     */
    public String getEncryptionScope() {
        return internalHeaders.getXMsEncryptionScope();
    }

    /**
     * Set the encryptionScope property: Returns the name of the encryption
     * scope used to encrypt the blob contents and application metadata.  Note
     * that the absence of this header implies use of the default account
     * encryption scope.
     *
     * @param encryptionScope the encryptionScope value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setEncryptionScope(String encryptionScope) {
        internalHeaders.setXMsEncryptionScope(encryptionScope);
        return this;
    }

    /**
     * Get the blobContentMd5 property: If the blob has a MD5 hash, and if
     * request contains range header (Range or x-ms-range), this response
     * header is returned with the value of the whole blob's MD5 value. This
     * value may or may not be equal to the value returned in Content-MD5
     * header, with the latter calculated from the requested range.
     *
     * @return the blobContentMd5 value.
     */
    public byte[] getBlobContentMd5() {
        return internalHeaders.getXMsBlobContentMd5();
    }

    /**
     * Set the blobContentMd5 property: If the blob has a MD5 hash, and if
     * request contains range header (Range or x-ms-range), this response
     * header is returned with the value of the whole blob's MD5 value. This
     * value may or may not be equal to the value returned in Content-MD5
     * header, with the latter calculated from the requested range.
     *
     * @param blobContentMd5 the blobContentMd5 value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setBlobContentMd5(byte[] blobContentMd5) {
        internalHeaders.setXMsBlobContentMd5(blobContentMd5);
        return this;
    }

    /**
     * Get the contentCrc64 property: If the request is to read a specified
     * range and the x-ms-range-get-content-crc64 is set to true, then the
     * request returns a crc64 for the range, as long as the range size is less
     * than or equal to 4 MB. If both x-ms-range-get-content-crc64 and
     * x-ms-range-get-content-md5 is specified in the same request, it will
     * fail with 400(Bad Request).
     *
     * @return the contentCrc64 value.
     */
    public byte[] getContentCrc64() {
        return internalHeaders.getXMsContentCrc64();
    }

    /**
     * Set the contentCrc64 property: If the request is to read a specified
     * range and the x-ms-range-get-content-crc64 is set to true, then the
     * request returns a crc64 for the range, as long as the range size is less
     * than or equal to 4 MB. If both x-ms-range-get-content-crc64 and
     * x-ms-range-get-content-md5 is specified in the same request, it will
     * fail with 400(Bad Request).
     *
     * @param contentCrc64 the contentCrc64 value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setContentCrc64(byte[] contentCrc64) {
        internalHeaders.setXMsContentCrc64(contentCrc64);
        return this;
    }

    /**
     * Get the errorCode property: The errorCode property.
     *
     * @return the errorCode value.
     */
    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * Set the errorCode property: The errorCode property.
     *
     * @param errorCode the errorCode value to set.
     * @return the BlobQueryHeaders object itself.
     */
    public BlobQueryHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}
