// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

/** The object returned in the QueueMessageList array when calling Peek Messages on a Queue. */
@JacksonXmlRootElement(localName = "QueueMessage")
@Fluent
public final class PeekedMessageItem {
    /*
     * The Id of the Message.
     */
    @JsonProperty(value = "MessageId", required = true)
    private String messageId;

    /*
     * The time the Message was inserted into the Queue.
     */
    @JsonProperty(value = "InsertionTime", required = true)
    private DateTimeRfc1123 insertionTime;

    /*
     * The time that the Message will expire and be automatically deleted.
     */
    @JsonProperty(value = "ExpirationTime", required = true)
    private DateTimeRfc1123 expirationTime;

    /*
     * The number of times the message has been dequeued.
     */
    @JsonProperty(value = "DequeueCount", required = true)
    private long dequeueCount;

    /*
     * The content of the Message.
     */
    private BinaryData body;

    /**
     * Get the messageId property: The Id of the Message.
     *
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The Id of the Message.
     *
     * @param messageId the messageId value to set.
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the insertionTime property: The time the Message was inserted into the Queue.
     *
     * @return the insertionTime value.
     */
    public OffsetDateTime getInsertionTime() {
        if (this.insertionTime == null) {
            return null;
        }
        return this.insertionTime.getDateTime();
    }

    /**
     * Set the insertionTime property: The time the Message was inserted into the Queue.
     *
     * @param insertionTime the insertionTime value to set.
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem setInsertionTime(OffsetDateTime insertionTime) {
        if (insertionTime == null) {
            this.insertionTime = null;
        } else {
            this.insertionTime = new DateTimeRfc1123(insertionTime);
        }
        return this;
    }

    /**
     * Get the expirationTime property: The time that the Message will expire and be automatically deleted.
     *
     * @return the expirationTime value.
     */
    public OffsetDateTime getExpirationTime() {
        if (this.expirationTime == null) {
            return null;
        }
        return this.expirationTime.getDateTime();
    }

    /**
     * Set the expirationTime property: The time that the Message will expire and be automatically deleted.
     *
     * @param expirationTime the expirationTime value to set.
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem setExpirationTime(OffsetDateTime expirationTime) {
        if (expirationTime == null) {
            this.expirationTime = null;
        } else {
            this.expirationTime = new DateTimeRfc1123(expirationTime);
        }
        return this;
    }

    /**
     * Get the dequeueCount property: The number of times the message has been dequeued.
     *
     * @return the dequeueCount value.
     */
    public long getDequeueCount() {
        return this.dequeueCount;
    }

    /**
     * Set the dequeueCount property: The number of times the message has been dequeued.
     *
     * @param dequeueCount the dequeueCount value to set.
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem setDequeueCount(long dequeueCount) {
        this.dequeueCount = dequeueCount;
        return this;
    }

    /**
     * Get the messageText property: The content of the Message.
     *
     * @return the messageText value.
     * @deprecated use {@link #getBody()} instead.
     */
    @Deprecated
    public String getMessageText() {
        return this.body == null ? null : this.body.toString();
    }

    /**
     * Set the messageText property: The content of the Message.
     *
     * @param messageText the messageText value to set.
     * @return the PeekedMessageItem object itself.
     * @deprecated use {@link #setBody(BinaryData)} instead.
     */
    @Deprecated
    public PeekedMessageItem setMessageText(String messageText) {
        this.body = messageText == null ? null : BinaryData.fromString(messageText);
        return this;
    }


    /**
     * Get the body property: The content of the Message.
     *
     * @return the body value.
     */
    public BinaryData getBody() {
        return this.body;
    }

    /**
     * Set the body property: The content of the Message.
     *
     * @param body the body value to set.
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem setBody(BinaryData body) {
        this.body = body;
        return this;
    }
}
