// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The object returned in the QueueMessageList array when calling Put Message on a Queue.
 */
@Fluent
public final class SendMessageResult implements XmlSerializable<SendMessageResult> {
    /*
     * The Id of the Message.
     */
    private String messageId;

    /*
     * The time the Message was inserted into the Queue.
     */
    private DateTimeRfc1123 insertionTime;

    /*
     * The time that the Message will expire and be automatically deleted.
     */
    private DateTimeRfc1123 expirationTime;

    /*
     * This value is required to delete the Message. If deletion fails using this popreceipt then the message has been dequeued by another client.
     */
    private String popReceipt;

    /*
     * The time that the message will again become visible in the Queue.
     */
    private DateTimeRfc1123 timeNextVisible;

    /**
     * Creates an instance of SendMessageResult class.
     */
    public SendMessageResult() {
    }

    /**
     * Get the messageId property: The Id of the Message.
     * 
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The Id of the Message.
     * 
     * @param messageId the messageId value to set.
     * @return the SendMessageResult object itself.
     */
    public SendMessageResult setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the insertionTime property: The time the Message was inserted into the Queue.
     * 
     * @return the insertionTime value.
     */
    public OffsetDateTime getInsertionTime() {
        if (this.insertionTime == null) {
            return null;
        }
        return this.insertionTime.getDateTime();
    }

    /**
     * Set the insertionTime property: The time the Message was inserted into the Queue.
     * 
     * @param insertionTime the insertionTime value to set.
     * @return the SendMessageResult object itself.
     */
    public SendMessageResult setInsertionTime(OffsetDateTime insertionTime) {
        if (insertionTime == null) {
            this.insertionTime = null;
        } else {
            this.insertionTime = new DateTimeRfc1123(insertionTime);
        }
        return this;
    }

    /**
     * Get the expirationTime property: The time that the Message will expire and be automatically deleted.
     * 
     * @return the expirationTime value.
     */
    public OffsetDateTime getExpirationTime() {
        if (this.expirationTime == null) {
            return null;
        }
        return this.expirationTime.getDateTime();
    }

    /**
     * Set the expirationTime property: The time that the Message will expire and be automatically deleted.
     * 
     * @param expirationTime the expirationTime value to set.
     * @return the SendMessageResult object itself.
     */
    public SendMessageResult setExpirationTime(OffsetDateTime expirationTime) {
        if (expirationTime == null) {
            this.expirationTime = null;
        } else {
            this.expirationTime = new DateTimeRfc1123(expirationTime);
        }
        return this;
    }

    /**
     * Get the popReceipt property: This value is required to delete the Message. If deletion fails using this
     * popreceipt then the message has been dequeued by another client.
     * 
     * @return the popReceipt value.
     */
    public String getPopReceipt() {
        return this.popReceipt;
    }

    /**
     * Set the popReceipt property: This value is required to delete the Message. If deletion fails using this
     * popreceipt then the message has been dequeued by another client.
     * 
     * @param popReceipt the popReceipt value to set.
     * @return the SendMessageResult object itself.
     */
    public SendMessageResult setPopReceipt(String popReceipt) {
        this.popReceipt = popReceipt;
        return this;
    }

    /**
     * Get the timeNextVisible property: The time that the message will again become visible in the Queue.
     * 
     * @return the timeNextVisible value.
     */
    public OffsetDateTime getTimeNextVisible() {
        if (this.timeNextVisible == null) {
            return null;
        }
        return this.timeNextVisible.getDateTime();
    }

    /**
     * Set the timeNextVisible property: The time that the message will again become visible in the Queue.
     * 
     * @param timeNextVisible the timeNextVisible value to set.
     * @return the SendMessageResult object itself.
     */
    public SendMessageResult setTimeNextVisible(OffsetDateTime timeNextVisible) {
        if (timeNextVisible == null) {
            this.timeNextVisible = null;
        } else {
            this.timeNextVisible = new DateTimeRfc1123(timeNextVisible);
        }
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueMessage" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("MessageId", this.messageId);
        xmlWriter.writeStringElement("InsertionTime", Objects.toString(this.insertionTime, null));
        xmlWriter.writeStringElement("ExpirationTime", Objects.toString(this.expirationTime, null));
        xmlWriter.writeStringElement("PopReceipt", this.popReceipt);
        xmlWriter.writeStringElement("TimeNextVisible", Objects.toString(this.timeNextVisible, null));
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of SendMessageResult from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of SendMessageResult if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the SendMessageResult.
     */
    public static SendMessageResult fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of SendMessageResult from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of SendMessageResult if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the SendMessageResult.
     */
    public static SendMessageResult fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueMessage" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            SendMessageResult deserializedSendMessageResult = new SendMessageResult();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("MessageId".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.messageId = reader.getStringElement();
                } else if ("InsertionTime".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.insertionTime = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("ExpirationTime".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.expirationTime = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("PopReceipt".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.popReceipt = reader.getStringElement();
                } else if ("TimeNextVisible".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.timeNextVisible = reader.getNullableElement(DateTimeRfc1123::new);
                } else {
                    reader.skipElement();
                }
            }

            return deserializedSendMessageResult;
        });
    }
}
