// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties that define an API key of an Application Insights Component. */
@Fluent
public final class ApplicationInsightsComponentApiKeyInner {
    /*
     * The unique ID of the API key inside an Application Insights component.
     * It is auto generated when the API key is created.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The API key value. It will be only return once when the API Key was
     * created.
     */
    @JsonProperty(value = "apiKey", access = JsonProperty.Access.WRITE_ONLY)
    private String apiKey;

    /*
     * The create date of this API key.
     */
    @JsonProperty(value = "createdDate")
    private String createdDate;

    /*
     * The name of the API key.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The read access rights of this API Key.
     */
    @JsonProperty(value = "linkedReadProperties")
    private List<String> linkedReadProperties;

    /*
     * The write access rights of this API Key.
     */
    @JsonProperty(value = "linkedWriteProperties")
    private List<String> linkedWriteProperties;

    /**
     * Get the id property: The unique ID of the API key inside an Application Insights component. It is auto generated
     * when the API key is created.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the apiKey property: The API key value. It will be only return once when the API Key was created.
     *
     * @return the apiKey value.
     */
    public String apiKey() {
        return this.apiKey;
    }

    /**
     * Get the createdDate property: The create date of this API key.
     *
     * @return the createdDate value.
     */
    public String createdDate() {
        return this.createdDate;
    }

    /**
     * Set the createdDate property: The create date of this API key.
     *
     * @param createdDate the createdDate value to set.
     * @return the ApplicationInsightsComponentApiKeyInner object itself.
     */
    public ApplicationInsightsComponentApiKeyInner withCreatedDate(String createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    /**
     * Get the name property: The name of the API key.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the API key.
     *
     * @param name the name value to set.
     * @return the ApplicationInsightsComponentApiKeyInner object itself.
     */
    public ApplicationInsightsComponentApiKeyInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the linkedReadProperties property: The read access rights of this API Key.
     *
     * @return the linkedReadProperties value.
     */
    public List<String> linkedReadProperties() {
        return this.linkedReadProperties;
    }

    /**
     * Set the linkedReadProperties property: The read access rights of this API Key.
     *
     * @param linkedReadProperties the linkedReadProperties value to set.
     * @return the ApplicationInsightsComponentApiKeyInner object itself.
     */
    public ApplicationInsightsComponentApiKeyInner withLinkedReadProperties(List<String> linkedReadProperties) {
        this.linkedReadProperties = linkedReadProperties;
        return this;
    }

    /**
     * Get the linkedWriteProperties property: The write access rights of this API Key.
     *
     * @return the linkedWriteProperties value.
     */
    public List<String> linkedWriteProperties() {
        return this.linkedWriteProperties;
    }

    /**
     * Set the linkedWriteProperties property: The write access rights of this API Key.
     *
     * @param linkedWriteProperties the linkedWriteProperties value to set.
     * @return the ApplicationInsightsComponentApiKeyInner object itself.
     */
    public ApplicationInsightsComponentApiKeyInner withLinkedWriteProperties(List<String> linkedWriteProperties) {
        this.linkedWriteProperties = linkedWriteProperties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
