// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentInner;
import com.azure.resourcemanager.applicationinsights.fluent.models.ComponentPurgeResponseInner;
import com.azure.resourcemanager.applicationinsights.fluent.models.ComponentPurgeStatusResponseInner;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeBody;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeResponse;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeStatusResponse;
import com.azure.resourcemanager.applicationinsights.models.Components;

public final class ComponentsImpl implements Components {
    private static final ClientLogger LOGGER = new ClientLogger(ComponentsImpl.class);

    private final ComponentsClient innerClient;

    private final com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager;

    public ComponentsImpl(
        ComponentsClient innerClient,
        com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ApplicationInsightsComponent> list() {
        PagedIterable<ApplicationInsightsComponentInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentImpl(inner1, this.manager()));
    }

    public PagedIterable<ApplicationInsightsComponent> list(Context context) {
        PagedIterable<ApplicationInsightsComponentInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentImpl(inner1, this.manager()));
    }

    public PagedIterable<ApplicationInsightsComponent> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ApplicationInsightsComponentInner> inner =
            this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentImpl(inner1, this.manager()));
    }

    public PagedIterable<ApplicationInsightsComponent> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ApplicationInsightsComponentInner> inner =
            this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentImpl(inner1, this.manager()));
    }

    public void deleteByResourceGroup(String resourceGroupName, String resourceName) {
        this.serviceClient().delete(resourceGroupName, resourceName);
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, context);
    }

    public ApplicationInsightsComponent getByResourceGroup(String resourceGroupName, String resourceName) {
        ApplicationInsightsComponentInner inner =
            this.serviceClient().getByResourceGroup(resourceGroupName, resourceName);
        if (inner != null) {
            return new ApplicationInsightsComponentImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApplicationInsightsComponent> getByResourceGroupWithResponse(
        String resourceGroupName, String resourceName, Context context) {
        Response<ApplicationInsightsComponentInner> inner =
            this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ApplicationInsightsComponentImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ComponentPurgeResponse purge(String resourceGroupName, String resourceName, ComponentPurgeBody body) {
        ComponentPurgeResponseInner inner = this.serviceClient().purge(resourceGroupName, resourceName, body);
        if (inner != null) {
            return new ComponentPurgeResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ComponentPurgeResponse> purgeWithResponse(
        String resourceGroupName, String resourceName, ComponentPurgeBody body, Context context) {
        Response<ComponentPurgeResponseInner> inner =
            this.serviceClient().purgeWithResponse(resourceGroupName, resourceName, body, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ComponentPurgeResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ComponentPurgeStatusResponse getPurgeStatus(String resourceGroupName, String resourceName, String purgeId) {
        ComponentPurgeStatusResponseInner inner =
            this.serviceClient().getPurgeStatus(resourceGroupName, resourceName, purgeId);
        if (inner != null) {
            return new ComponentPurgeStatusResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ComponentPurgeStatusResponse> getPurgeStatusWithResponse(
        String resourceGroupName, String resourceName, String purgeId, Context context) {
        Response<ComponentPurgeStatusResponseInner> inner =
            this.serviceClient().getPurgeStatusWithResponse(resourceGroupName, resourceName, purgeId, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ComponentPurgeStatusResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApplicationInsightsComponent getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    public Response<ApplicationInsightsComponent> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, resourceName, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, resourceName, context);
    }

    private ComponentsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    public ApplicationInsightsComponentImpl define(String name) {
        return new ApplicationInsightsComponentImpl(name, this.manager());
    }
}
