// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for IngestionMode. */
public final class IngestionMode extends ExpandableStringEnum<IngestionMode> {
    /** Static value ApplicationInsights for IngestionMode. */
    public static final IngestionMode APPLICATION_INSIGHTS = fromString("ApplicationInsights");

    /** Static value ApplicationInsightsWithDiagnosticSettings for IngestionMode. */
    public static final IngestionMode APPLICATION_INSIGHTS_WITH_DIAGNOSTIC_SETTINGS =
        fromString("ApplicationInsightsWithDiagnosticSettings");

    /** Static value LogAnalytics for IngestionMode. */
    public static final IngestionMode LOG_ANALYTICS = fromString("LogAnalytics");

    /**
     * Creates or finds a IngestionMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding IngestionMode.
     */
    @JsonCreator
    public static IngestionMode fromString(String name) {
        return fromString(name, IngestionMode.class);
    }

    /**
     * Gets known IngestionMode values.
     *
     * @return known IngestionMode values.
     */
    public static Collection<IngestionMode> values() {
        return values(IngestionMode.class);
    }
}
