// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ItemType. */
public final class ItemType extends ExpandableStringEnum<ItemType> {
    /** Static value none for ItemType. */
    public static final ItemType NONE = fromString("none");

    /** Static value query for ItemType. */
    public static final ItemType QUERY = fromString("query");

    /** Static value recent for ItemType. */
    public static final ItemType RECENT = fromString("recent");

    /** Static value function for ItemType. */
    public static final ItemType FUNCTION = fromString("function");

    /**
     * Creates or finds a ItemType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ItemType.
     */
    @JsonCreator
    public static ItemType fromString(String name) {
        return fromString(name, ItemType.class);
    }

    /**
     * Gets known ItemType values.
     *
     * @return known ItemType values.
     */
    public static Collection<ItemType> values() {
        return values(ItemType.class);
    }
}
