// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for RequestSource. */
public final class RequestSource extends ExpandableStringEnum<RequestSource> {
    /** Static value rest for RequestSource. */
    public static final RequestSource REST = fromString("rest");

    /**
     * Creates or finds a RequestSource from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RequestSource.
     */
    @JsonCreator
    public static RequestSource fromString(String name) {
        return fromString(name, RequestSource.class);
    }

    /**
     * Gets known RequestSource values.
     *
     * @return known RequestSource values.
     */
    public static Collection<RequestSource> values() {
        return values(RequestSource.class);
    }
}
