// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Localized template data and gallery information. */
@Fluent
public final class WorkbookTemplateLocalizedGallery {
    /*
     * Valid JSON object containing workbook template payload.
     */
    @JsonProperty(value = "templateData")
    private Object templateData;

    /*
     * Workbook galleries supported by the template.
     */
    @JsonProperty(value = "galleries")
    private List<WorkbookTemplateGallery> galleries;

    /**
     * Get the templateData property: Valid JSON object containing workbook template payload.
     *
     * @return the templateData value.
     */
    public Object templateData() {
        return this.templateData;
    }

    /**
     * Set the templateData property: Valid JSON object containing workbook template payload.
     *
     * @param templateData the templateData value to set.
     * @return the WorkbookTemplateLocalizedGallery object itself.
     */
    public WorkbookTemplateLocalizedGallery withTemplateData(Object templateData) {
        this.templateData = templateData;
        return this;
    }

    /**
     * Get the galleries property: Workbook galleries supported by the template.
     *
     * @return the galleries value.
     */
    public List<WorkbookTemplateGallery> galleries() {
        return this.galleries;
    }

    /**
     * Set the galleries property: Workbook galleries supported by the template.
     *
     * @param galleries the galleries value to set.
     * @return the WorkbookTemplateLocalizedGallery object itself.
     */
    public WorkbookTemplateLocalizedGallery withGalleries(List<WorkbookTemplateGallery> galleries) {
        this.galleries = galleries;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (galleries() != null) {
            galleries().forEach(e -> e.validate());
        }
    }
}
