// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.appplatform.models.ConfigServerProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Config Server resource. */
@Fluent
public final class ConfigServerResourceInner extends ProxyResource {
    /*
     * Properties of the Config Server resource
     */
    @JsonProperty(value = "properties")
    private ConfigServerProperties properties;

    /**
     * Get the properties property: Properties of the Config Server resource.
     *
     * @return the properties value.
     */
    public ConfigServerProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the Config Server resource.
     *
     * @param properties the properties value to set.
     * @return the ConfigServerResourceInner object itself.
     */
    public ConfigServerResourceInner withProperties(ConfigServerProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
