// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Buildpack group properties of the Builder. */
@Fluent
public final class BuildpacksGroupProperties {
    /*
     * Buildpack group name
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Buildpacks in the buildpack group
     */
    @JsonProperty(value = "buildpacks")
    private List<BuildpackProperties> buildpacks;

    /**
     * Get the name property: Buildpack group name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Buildpack group name.
     *
     * @param name the name value to set.
     * @return the BuildpacksGroupProperties object itself.
     */
    public BuildpacksGroupProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the buildpacks property: Buildpacks in the buildpack group.
     *
     * @return the buildpacks value.
     */
    public List<BuildpackProperties> buildpacks() {
        return this.buildpacks;
    }

    /**
     * Set the buildpacks property: Buildpacks in the buildpack group.
     *
     * @param buildpacks the buildpacks value to set.
     * @return the BuildpacksGroupProperties object itself.
     */
    public BuildpacksGroupProperties withBuildpacks(List<BuildpackProperties> buildpacks) {
        this.buildpacks = buildpacks;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (buildpacks() != null) {
            buildpacks().forEach(e -> e.validate());
        }
    }
}
