/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.BindingsClient;
import com.azure.resourcemanager.appplatform.fluent.models.BindingResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringAppImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringAppServiceBindingImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.models.BindingResourceProperties;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppServiceBinding;
import com.azure.resourcemanager.appplatform.models.SpringAppServiceBindings;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class SpringAppServiceBindingsImpl
extends ExternalChildResourcesNonCachedImpl<SpringAppServiceBindingImpl, SpringAppServiceBinding, BindingResourceInner, SpringAppImpl, SpringApp>
implements SpringAppServiceBindings {
    SpringAppServiceBindingsImpl(SpringAppImpl parent) {
        super((Object)parent, parent.taskGroup(), "SpringAppServiceBinding");
    }

    public SpringAppServiceBinding getById(String id) {
        return (SpringAppServiceBinding)this.getByIdAsync(id).block();
    }

    public Mono<SpringAppServiceBinding> getByIdAsync(String id) {
        return this.getByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public SpringAppServiceBinding getByName(String name) {
        return (SpringAppServiceBinding)this.getByNameAsync(name).block();
    }

    public Mono<SpringAppServiceBinding> getByNameAsync(String name) {
        return this.inner().getAsync(((SpringServiceImpl)this.parent().parent()).resourceGroupName(), ((SpringServiceImpl)this.parent().parent()).name(), this.parent().name(), name).map(this::wrapModel);
    }

    SpringAppServiceBindingImpl wrapModel(BindingResourceInner inner) {
        return inner == null ? null : new SpringAppServiceBindingImpl(inner.name(), this.parent(), inner);
    }

    public AppPlatformManager manager() {
        return this.parent().manager();
    }

    public SpringAppImpl parent() {
        return (SpringAppImpl)this.getParent();
    }

    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.inner().deleteAsync(((SpringServiceImpl)this.parent().parent()).resourceGroupName(), ((SpringServiceImpl)this.parent().parent()).name(), this.parent().name(), name);
    }

    public PagedIterable<SpringAppServiceBinding> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<SpringAppServiceBinding> listAsync() {
        return PagedConverter.mapPage(this.inner().listAsync(((SpringServiceImpl)this.parent().parent()).resourceGroupName(), ((SpringServiceImpl)this.parent().parent()).name(), this.parent().name()), this::wrapModel);
    }

    public BindingsClient inner() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getBindings();
    }

    SpringAppServiceBinding prepareCreateOrUpdate(String name, BindingResourceProperties properties) {
        return (SpringAppServiceBinding)this.prepareInlineDefine(new SpringAppServiceBindingImpl(name, this.parent(), new BindingResourceInner().withProperties(properties)));
    }

    void prepareDelete(String name) {
        this.prepareInlineRemove(new SpringAppServiceBindingImpl(name, this.parent(), new BindingResourceInner()));
    }
}

