// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Full view of network features for an app (presently VNET integration and Hybrid Connections). */
@Fluent
public final class NetworkFeaturesInner extends ProxyOnlyResource {
    /*
     * NetworkFeatures resource specific properties
     */
    @JsonProperty(value = "properties")
    private NetworkFeaturesProperties innerProperties;

    /**
     * Get the innerProperties property: NetworkFeatures resource specific properties.
     *
     * @return the innerProperties value.
     */
    private NetworkFeaturesProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public NetworkFeaturesInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the virtualNetworkName property: The Virtual Network name.
     *
     * @return the virtualNetworkName value.
     */
    public String virtualNetworkName() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkName();
    }

    /**
     * Get the virtualNetworkConnection property: The Virtual Network summary view.
     *
     * @return the virtualNetworkConnection value.
     */
    public VnetInfo virtualNetworkConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkConnection();
    }

    /**
     * Get the hybridConnections property: The Hybrid Connections summary view.
     *
     * @return the hybridConnections value.
     */
    public List<RelayServiceConnectionEntityInner> hybridConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridConnections();
    }

    /**
     * Get the hybridConnectionsV2 property: The Hybrid Connection V2 (Service Bus) view.
     *
     * @return the hybridConnectionsV2 value.
     */
    public List<HybridConnectionInner> hybridConnectionsV2() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridConnectionsV2();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
