// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.TriggeredJobRun;
import com.azure.resourcemanager.appservice.models.WebJobType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** TriggeredWebJob resource specific properties. */
@Fluent
public final class TriggeredWebJobProperties {
    /*
     * Latest job run information.
     */
    @JsonProperty(value = "latest_run")
    private TriggeredJobRun latestRun;

    /*
     * History URL.
     */
    @JsonProperty(value = "history_url")
    private String historyUrl;

    /*
     * Scheduler Logs URL.
     */
    @JsonProperty(value = "scheduler_logs_url")
    private String schedulerLogsUrl;

    /*
     * Run command.
     */
    @JsonProperty(value = "run_command")
    private String runCommand;

    /*
     * Job URL.
     */
    @JsonProperty(value = "url")
    private String url;

    /*
     * Extra Info URL.
     */
    @JsonProperty(value = "extra_info_url")
    private String extraInfoUrl;

    /*
     * Job type.
     */
    @JsonProperty(value = "web_job_type")
    private WebJobType webJobType;

    /*
     * Error information.
     */
    @JsonProperty(value = "error")
    private String error;

    /*
     * Using SDK?
     */
    @JsonProperty(value = "using_sdk")
    private Boolean usingSdk;

    /*
     * Property to allow or block all public traffic. Allowed Values:
     * 'Enabled', 'Disabled' or an empty string.
     */
    @JsonProperty(value = "publicNetworkAccess")
    private String publicNetworkAccess;

    /*
     * Checks if Customer provided storage account is required
     */
    @JsonProperty(value = "storageAccountRequired")
    private Boolean storageAccountRequired;

    /*
     * Job settings.
     */
    @JsonProperty(value = "settings")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> settings;

    /**
     * Get the latestRun property: Latest job run information.
     *
     * @return the latestRun value.
     */
    public TriggeredJobRun latestRun() {
        return this.latestRun;
    }

    /**
     * Set the latestRun property: Latest job run information.
     *
     * @param latestRun the latestRun value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withLatestRun(TriggeredJobRun latestRun) {
        this.latestRun = latestRun;
        return this;
    }

    /**
     * Get the historyUrl property: History URL.
     *
     * @return the historyUrl value.
     */
    public String historyUrl() {
        return this.historyUrl;
    }

    /**
     * Set the historyUrl property: History URL.
     *
     * @param historyUrl the historyUrl value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withHistoryUrl(String historyUrl) {
        this.historyUrl = historyUrl;
        return this;
    }

    /**
     * Get the schedulerLogsUrl property: Scheduler Logs URL.
     *
     * @return the schedulerLogsUrl value.
     */
    public String schedulerLogsUrl() {
        return this.schedulerLogsUrl;
    }

    /**
     * Set the schedulerLogsUrl property: Scheduler Logs URL.
     *
     * @param schedulerLogsUrl the schedulerLogsUrl value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withSchedulerLogsUrl(String schedulerLogsUrl) {
        this.schedulerLogsUrl = schedulerLogsUrl;
        return this;
    }

    /**
     * Get the runCommand property: Run command.
     *
     * @return the runCommand value.
     */
    public String runCommand() {
        return this.runCommand;
    }

    /**
     * Set the runCommand property: Run command.
     *
     * @param runCommand the runCommand value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withRunCommand(String runCommand) {
        this.runCommand = runCommand;
        return this;
    }

    /**
     * Get the url property: Job URL.
     *
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: Job URL.
     *
     * @param url the url value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the extraInfoUrl property: Extra Info URL.
     *
     * @return the extraInfoUrl value.
     */
    public String extraInfoUrl() {
        return this.extraInfoUrl;
    }

    /**
     * Set the extraInfoUrl property: Extra Info URL.
     *
     * @param extraInfoUrl the extraInfoUrl value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withExtraInfoUrl(String extraInfoUrl) {
        this.extraInfoUrl = extraInfoUrl;
        return this;
    }

    /**
     * Get the webJobType property: Job type.
     *
     * @return the webJobType value.
     */
    public WebJobType webJobType() {
        return this.webJobType;
    }

    /**
     * Set the webJobType property: Job type.
     *
     * @param webJobType the webJobType value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withWebJobType(WebJobType webJobType) {
        this.webJobType = webJobType;
        return this;
    }

    /**
     * Get the error property: Error information.
     *
     * @return the error value.
     */
    public String error() {
        return this.error;
    }

    /**
     * Set the error property: Error information.
     *
     * @param error the error value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withError(String error) {
        this.error = error;
        return this;
    }

    /**
     * Get the usingSdk property: Using SDK?.
     *
     * @return the usingSdk value.
     */
    public Boolean usingSdk() {
        return this.usingSdk;
    }

    /**
     * Set the usingSdk property: Using SDK?.
     *
     * @param usingSdk the usingSdk value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withUsingSdk(Boolean usingSdk) {
        this.usingSdk = usingSdk;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Property to allow or block all public traffic. Allowed Values: 'Enabled',
     * 'Disabled' or an empty string.
     *
     * @return the publicNetworkAccess value.
     */
    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Property to allow or block all public traffic. Allowed Values: 'Enabled',
     * 'Disabled' or an empty string.
     *
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the storageAccountRequired property: Checks if Customer provided storage account is required.
     *
     * @return the storageAccountRequired value.
     */
    public Boolean storageAccountRequired() {
        return this.storageAccountRequired;
    }

    /**
     * Set the storageAccountRequired property: Checks if Customer provided storage account is required.
     *
     * @param storageAccountRequired the storageAccountRequired value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withStorageAccountRequired(Boolean storageAccountRequired) {
        this.storageAccountRequired = storageAccountRequired;
        return this;
    }

    /**
     * Get the settings property: Job settings.
     *
     * @return the settings value.
     */
    public Map<String, Object> settings() {
        return this.settings;
    }

    /**
     * Set the settings property: Job settings.
     *
     * @param settings the settings value to set.
     * @return the TriggeredWebJobProperties object itself.
     */
    public TriggeredWebJobProperties withSettings(Map<String, Object> settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (latestRun() != null) {
            latestRun().validate();
        }
    }
}
