// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.fluent.models.DeletedAppRestoreRequestProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Details about restoring a deleted app. */
@Fluent
public final class DeletedAppRestoreRequest extends ProxyOnlyResource {
    /*
     * DeletedAppRestoreRequest resource specific properties
     */
    @JsonProperty(value = "properties")
    private DeletedAppRestoreRequestProperties innerProperties;

    /**
     * Get the innerProperties property: DeletedAppRestoreRequest resource specific properties.
     *
     * @return the innerProperties value.
     */
    private DeletedAppRestoreRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedAppRestoreRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the deletedSiteId property: ARM resource ID of the deleted app. Example:
     * /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
     *
     * @return the deletedSiteId value.
     */
    public String deletedSiteId() {
        return this.innerProperties() == null ? null : this.innerProperties().deletedSiteId();
    }

    /**
     * Set the deletedSiteId property: ARM resource ID of the deleted app. Example:
     * /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
     *
     * @param deletedSiteId the deletedSiteId value to set.
     * @return the DeletedAppRestoreRequest object itself.
     */
    public DeletedAppRestoreRequest withDeletedSiteId(String deletedSiteId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeletedAppRestoreRequestProperties();
        }
        this.innerProperties().withDeletedSiteId(deletedSiteId);
        return this;
    }

    /**
     * Get the recoverConfiguration property: If true, deleted site configuration, in addition to content, will be
     * restored.
     *
     * @return the recoverConfiguration value.
     */
    public Boolean recoverConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverConfiguration();
    }

    /**
     * Set the recoverConfiguration property: If true, deleted site configuration, in addition to content, will be
     * restored.
     *
     * @param recoverConfiguration the recoverConfiguration value to set.
     * @return the DeletedAppRestoreRequest object itself.
     */
    public DeletedAppRestoreRequest withRecoverConfiguration(Boolean recoverConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeletedAppRestoreRequestProperties();
        }
        this.innerProperties().withRecoverConfiguration(recoverConfiguration);
        return this;
    }

    /**
     * Get the snapshotTime property: Point in time to restore the deleted app from, formatted as a DateTime string. If
     * unspecified, default value is the time that the app was deleted.
     *
     * @return the snapshotTime value.
     */
    public String snapshotTime() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotTime();
    }

    /**
     * Set the snapshotTime property: Point in time to restore the deleted app from, formatted as a DateTime string. If
     * unspecified, default value is the time that the app was deleted.
     *
     * @param snapshotTime the snapshotTime value to set.
     * @return the DeletedAppRestoreRequest object itself.
     */
    public DeletedAppRestoreRequest withSnapshotTime(String snapshotTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeletedAppRestoreRequestProperties();
        }
        this.innerProperties().withSnapshotTime(snapshotTime);
        return this;
    }

    /**
     * Get the useDRSecondary property: If true, the snapshot is retrieved from DRSecondary endpoint.
     *
     * @return the useDRSecondary value.
     */
    public Boolean useDRSecondary() {
        return this.innerProperties() == null ? null : this.innerProperties().useDRSecondary();
    }

    /**
     * Set the useDRSecondary property: If true, the snapshot is retrieved from DRSecondary endpoint.
     *
     * @param useDRSecondary the useDRSecondary value to set.
     * @return the DeletedAppRestoreRequest object itself.
     */
    public DeletedAppRestoreRequest withUseDRSecondary(Boolean useDRSecondary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeletedAppRestoreRequestProperties();
        }
        this.innerProperties().withUseDRSecondary(useDRSecondary);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
