// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Container App Private Registry. */
@Fluent
public final class RegistryCredentials {
    /*
     * Container Registry Server
     */
    @JsonProperty(value = "server")
    private String server;

    /*
     * Container Registry Username
     */
    @JsonProperty(value = "username")
    private String username;

    /*
     * The name of the Secret that contains the registry login password
     */
    @JsonProperty(value = "passwordSecretRef")
    private String passwordSecretRef;

    /**
     * Get the server property: Container Registry Server.
     *
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: Container Registry Server.
     *
     * @param server the server value to set.
     * @return the RegistryCredentials object itself.
     */
    public RegistryCredentials withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the username property: Container Registry Username.
     *
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: Container Registry Username.
     *
     * @param username the username value to set.
     * @return the RegistryCredentials object itself.
     */
    public RegistryCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the passwordSecretRef property: The name of the Secret that contains the registry login password.
     *
     * @return the passwordSecretRef value.
     */
    public String passwordSecretRef() {
        return this.passwordSecretRef;
    }

    /**
     * Set the passwordSecretRef property: The name of the Secret that contains the registry login password.
     *
     * @param passwordSecretRef the passwordSecretRef value to set.
     * @return the RegistryCredentials object itself.
     */
    public RegistryCredentials withPasswordSecretRef(String passwordSecretRef) {
        this.passwordSecretRef = passwordSecretRef;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
