// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Container App scaling configurations. */
@Fluent
public final class Scale {
    /*
     * Optional. Minimum number of container replicas.
     */
    @JsonProperty(value = "minReplicas")
    private Integer minReplicas;

    /*
     * Optional. Maximum number of container replicas. Defaults to 10 if not
     * set.
     */
    @JsonProperty(value = "maxReplicas")
    private Integer maxReplicas;

    /*
     * Scaling rules.
     */
    @JsonProperty(value = "rules")
    private List<ScaleRule> rules;

    /**
     * Get the minReplicas property: Optional. Minimum number of container replicas.
     *
     * @return the minReplicas value.
     */
    public Integer minReplicas() {
        return this.minReplicas;
    }

    /**
     * Set the minReplicas property: Optional. Minimum number of container replicas.
     *
     * @param minReplicas the minReplicas value to set.
     * @return the Scale object itself.
     */
    public Scale withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    /**
     * Get the maxReplicas property: Optional. Maximum number of container replicas. Defaults to 10 if not set.
     *
     * @return the maxReplicas value.
     */
    public Integer maxReplicas() {
        return this.maxReplicas;
    }

    /**
     * Set the maxReplicas property: Optional. Maximum number of container replicas. Defaults to 10 if not set.
     *
     * @param maxReplicas the maxReplicas value to set.
     * @return the Scale object itself.
     */
    public Scale withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    /**
     * Get the rules property: Scaling rules.
     *
     * @return the rules value.
     */
    public List<ScaleRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: Scaling rules.
     *
     * @param rules the rules value to set.
     * @return the Scale object itself.
     */
    public Scale withRules(List<ScaleRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }
}
