// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserInvitationRequestResourceProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Static sites user roles invitation resource. */
@Fluent
public final class StaticSiteUserInvitationRequestResource extends ProxyOnlyResource {
    /*
     * StaticSiteUserInvitationRequestResource resource specific properties
     */
    @JsonProperty(value = "properties")
    private StaticSiteUserInvitationRequestResourceProperties innerProperties;

    /**
     * Get the innerProperties property: StaticSiteUserInvitationRequestResource resource specific properties.
     *
     * @return the innerProperties value.
     */
    private StaticSiteUserInvitationRequestResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public StaticSiteUserInvitationRequestResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the domain property: The domain name for the static site custom domain.
     *
     * @return the domain value.
     */
    public String domain() {
        return this.innerProperties() == null ? null : this.innerProperties().domain();
    }

    /**
     * Set the domain property: The domain name for the static site custom domain.
     *
     * @param domain the domain value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withDomain(String domain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withDomain(domain);
        return this;
    }

    /**
     * Get the provider property: The identity provider for the static site user.
     *
     * @return the provider value.
     */
    public String provider() {
        return this.innerProperties() == null ? null : this.innerProperties().provider();
    }

    /**
     * Set the provider property: The identity provider for the static site user.
     *
     * @param provider the provider value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withProvider(String provider) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withProvider(provider);
        return this;
    }

    /**
     * Get the userDetails property: The user id for the static site user.
     *
     * @return the userDetails value.
     */
    public String userDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().userDetails();
    }

    /**
     * Set the userDetails property: The user id for the static site user.
     *
     * @param userDetails the userDetails value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withUserDetails(String userDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withUserDetails(userDetails);
        return this;
    }

    /**
     * Get the roles property: The roles for the static site user, in free-form string format.
     *
     * @return the roles value.
     */
    public String roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: The roles for the static site user, in free-form string format.
     *
     * @param roles the roles value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withRoles(String roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Get the numHoursToExpiration property: The number of hours the sas token stays valid.
     *
     * @return the numHoursToExpiration value.
     */
    public Integer numHoursToExpiration() {
        return this.innerProperties() == null ? null : this.innerProperties().numHoursToExpiration();
    }

    /**
     * Set the numHoursToExpiration property: The number of hours the sas token stays valid.
     *
     * @param numHoursToExpiration the numHoursToExpiration value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withNumHoursToExpiration(Integer numHoursToExpiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withNumHoursToExpiration(numHoursToExpiration);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
