// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for UnauthenticatedClientAction. */
public enum UnauthenticatedClientAction {
    /** Enum value RedirectToLoginPage. */
    REDIRECT_TO_LOGIN_PAGE("RedirectToLoginPage"),

    /** Enum value AllowAnonymous. */
    ALLOW_ANONYMOUS("AllowAnonymous");

    /** The actual serialized value for a UnauthenticatedClientAction instance. */
    private final String value;

    UnauthenticatedClientAction(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a UnauthenticatedClientAction instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed UnauthenticatedClientAction object, or null if unable to parse.
     */
    @JsonCreator
    public static UnauthenticatedClientAction fromString(String value) {
        UnauthenticatedClientAction[] items = UnauthenticatedClientAction.values();
        for (UnauthenticatedClientAction item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
