// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The sku type. */
@Fluent
public final class WorkflowSku {
    /*
     * The name.
     */
    @JsonProperty(value = "name", required = true)
    private WorkflowSkuName name;

    /*
     * The reference to plan.
     */
    @JsonProperty(value = "plan")
    private ResourceReference plan;

    /**
     * Get the name property: The name.
     *
     * @return the name value.
     */
    public WorkflowSkuName name() {
        return this.name;
    }

    /**
     * Set the name property: The name.
     *
     * @param name the name value to set.
     * @return the WorkflowSku object itself.
     */
    public WorkflowSku withName(WorkflowSkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the plan property: The reference to plan.
     *
     * @return the plan value.
     */
    public ResourceReference plan() {
        return this.plan;
    }

    /**
     * Set the plan property: The reference to plan.
     *
     * @param plan the plan value to set.
     * @return the WorkflowSku object itself.
     */
    public WorkflowSku withPlan(ResourceReference plan) {
        this.plan = plan;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model WorkflowSku"));
        }
        if (plan() != null) {
            plan().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkflowSku.class);
}
