// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.EligibleChildResourceInner;

/** An instance of this class provides access to all the operations defined in EligibleChildResourcesClient. */
public interface EligibleChildResourcesClient {
    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @param filter The filter to apply on the operation. Use $filter=resourceType+eq+'Subscription' to filter on only
     *     resource of type = 'Subscription'. Use
     *     $filter=resourceType+eq+'subscription'+or+resourceType+eq+'resourcegroup' to filter on resource of type =
     *     'Subscription' or 'ResourceGroup'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<EligibleChildResourceInner> getAsync(String scope, String filter);

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<EligibleChildResourceInner> getAsync(String scope);

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<EligibleChildResourceInner> get(String scope);

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @param filter The filter to apply on the operation. Use $filter=resourceType+eq+'Subscription' to filter on only
     *     resource of type = 'Subscription'. Use
     *     $filter=resourceType+eq+'subscription'+or+resourceType+eq+'resourcegroup' to filter on resource of type =
     *     'Subscription' or 'ResourceGroup'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<EligibleChildResourceInner> get(String scope, String filter, Context context);
}
