// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentInner;
import com.azure.resourcemanager.authorization.models.RoleAssignmentCreateParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoleAssignmentsClient. */
public interface RoleAssignmentsClient
    extends InnerSupportsListing<RoleAssignmentInner>, InnerSupportsDelete<RoleAssignmentInner> {
    /**
     * List all role assignments that apply to a subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param tenantId Tenant ID for cross-tenant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleAssignmentInner> listAsync(String filter, String tenantId);

    /**
     * List all role assignments that apply to a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleAssignmentInner> listAsync();

    /**
     * List all role assignments that apply to a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleAssignmentInner> list();

    /**
     * List all role assignments that apply to a subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleAssignmentInner> list(String filter, String tenantId, Context context);

    /**
     * List all role assignments that apply to a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param tenantId Tenant ID for cross-tenant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName, String filter, String tenantId);

    /**
     * List all role assignments that apply to a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * List all role assignments that apply to a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleAssignmentInner> listByResourceGroup(String resourceGroupName);

    /**
     * List all role assignments that apply to a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleAssignmentInner> listByResourceGroup(
        String resourceGroupName, String filter, String tenantId, Context context);

    /**
     * List all role assignments that apply to a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The resource name.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param tenantId Tenant ID for cross-tenant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String resourceType,
        String resourceName,
        String filter,
        String tenantId);

    /**
     * List all role assignments that apply to a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleAssignmentInner> listForResourceAsync(
        String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName);

    /**
     * List all role assignments that apply to a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleAssignmentInner> listForResource(
        String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName);

    /**
     * List all role assignments that apply to a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The resource name.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleAssignmentInner> listForResource(
        String resourceGroupName,
        String resourceProviderNamespace,
        String resourceType,
        String resourceName,
        String filter,
        String tenantId,
        Context context);

    /**
     * Get a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param tenantId Tenant ID for cross-tenant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by scope and name along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleAssignmentInner>> getWithResponseAsync(String scope, String roleAssignmentName, String tenantId);

    /**
     * Get a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by scope and name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName);

    /**
     * Get a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by scope and name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleAssignmentInner> getWithResponse(
        String scope, String roleAssignmentName, String tenantId, Context context);

    /**
     * Get a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by scope and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleAssignmentInner get(String scope, String roleAssignmentName);

    /**
     * Create or update a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleAssignmentInner>> createWithResponseAsync(
        String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters);

    /**
     * Create or update a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleAssignmentInner> createAsync(
        String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters);

    /**
     * Create or update a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleAssignmentInner> createWithResponse(
        String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context);

    /**
     * Create or update a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleAssignmentInner create(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters);

    /**
     * Delete a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param tenantId Tenant ID for cross-tenant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleAssignmentInner>> deleteWithResponseAsync(
        String scope, String roleAssignmentName, String tenantId);

    /**
     * Delete a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName);

    /**
     * Delete a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleAssignmentInner> deleteWithResponse(
        String scope, String roleAssignmentName, String tenantId, Context context);

    /**
     * Delete a role assignment by scope and name.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleAssignmentInner delete(String scope, String roleAssignmentName);

    /**
     * List all role assignments that apply to a scope.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param skipToken The skipToken to apply on the operation. Use $skipToken={skiptoken} to return paged role
     *     assignments following the skipToken passed. Only supported on provider level calls.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope, String filter, String tenantId, String skipToken);

    /**
     * List all role assignments that apply to a scope.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope);

    /**
     * List all role assignments that apply to a scope.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleAssignmentInner> listForScope(String scope);

    /**
     * List all role assignments that apply to a scope.
     *
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param skipToken The skipToken to apply on the operation. Use $skipToken={skiptoken} to return paged role
     *     assignments following the skipToken passed. Only supported on provider level calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleAssignmentInner> listForScope(
        String scope, String filter, String tenantId, String skipToken, Context context);

    /**
     * Get a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @param tenantId Tenant ID for cross-tenant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleAssignmentInner>> getByIdWithResponseAsync(String roleAssignmentId, String tenantId);

    /**
     * Get a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleAssignmentInner> getByIdAsync(String roleAssignmentId);

    /**
     * Get a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleAssignmentInner> getByIdWithResponse(String roleAssignmentId, String tenantId, Context context);

    /**
     * Get a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleAssignmentInner getById(String roleAssignmentId);

    /**
     * Create or update a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleAssignmentInner>> createByIdWithResponseAsync(
        String roleAssignmentId, RoleAssignmentCreateParameters parameters);

    /**
     * Create or update a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleAssignmentInner> createByIdAsync(String roleAssignmentId, RoleAssignmentCreateParameters parameters);

    /**
     * Create or update a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @param parameters Parameters for the role assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleAssignmentInner> createByIdWithResponse(
        String roleAssignmentId, RoleAssignmentCreateParameters parameters, Context context);

    /**
     * Create or update a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleAssignmentInner createById(String roleAssignmentId, RoleAssignmentCreateParameters parameters);

    /**
     * Delete a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @param tenantId Tenant ID for cross-tenant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleAssignmentInner>> deleteByIdWithResponseAsync(String roleAssignmentId, String tenantId);

    /**
     * Delete a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleAssignmentInner> deleteByIdAsync(String roleAssignmentId);

    /**
     * Delete a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @param tenantId Tenant ID for cross-tenant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleAssignmentInner> deleteByIdWithResponse(String roleAssignmentId, String tenantId, Context context);

    /**
     * Delete a role assignment by ID.
     *
     * @param roleAssignmentId The fully qualified ID of the role assignment including scope, resource name, and
     *     resource type. Format: /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}.
     *     Example:
     *     /subscriptions/&lt;SUB_ID&gt;/resourcegroups/&lt;RESOURCE_GROUP&gt;/providers/Microsoft.Authorization/roleAssignments/&lt;ROLE_ASSIGNMENT_NAME&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleAssignmentInner deleteById(String roleAssignmentId);
}
