// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.authorization.models.DenyAssignmentPermission;
import com.azure.resourcemanager.authorization.models.Principal;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Deny assignment properties. */
@Fluent
public final class DenyAssignmentProperties {
    /*
     * The display name of the deny assignment.
     */
    @JsonProperty(value = "denyAssignmentName")
    private String denyAssignmentName;

    /*
     * The description of the deny assignment.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * An array of permissions that are denied by the deny assignment.
     */
    @JsonProperty(value = "permissions")
    private List<DenyAssignmentPermission> permissions;

    /*
     * The deny assignment scope.
     */
    @JsonProperty(value = "scope")
    private String scope;

    /*
     * Determines if the deny assignment applies to child scopes. Default value is false.
     */
    @JsonProperty(value = "doNotApplyToChildScopes")
    private Boolean doNotApplyToChildScopes;

    /*
     * Array of principals to which the deny assignment applies.
     */
    @JsonProperty(value = "principals")
    private List<Principal> principals;

    /*
     * Array of principals to which the deny assignment does not apply.
     */
    @JsonProperty(value = "excludePrincipals")
    private List<Principal> excludePrincipals;

    /*
     * Specifies whether this deny assignment was created by Azure and cannot be edited or deleted.
     */
    @JsonProperty(value = "isSystemProtected")
    private Boolean isSystemProtected;

    /*
     * The conditions on the deny assignment. This limits the resources it can be assigned to. e.g.:
     * @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase
     * 'foo_storage_container'
     */
    @JsonProperty(value = "condition")
    private String condition;

    /*
     * Version of the condition.
     */
    @JsonProperty(value = "conditionVersion")
    private String conditionVersion;

    /*
     * Time it was created
     */
    @JsonProperty(value = "createdOn", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdOn;

    /*
     * Time it was updated
     */
    @JsonProperty(value = "updatedOn", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedOn;

    /*
     * Id of the user who created the assignment
     */
    @JsonProperty(value = "createdBy", access = JsonProperty.Access.WRITE_ONLY)
    private String createdBy;

    /*
     * Id of the user who updated the assignment
     */
    @JsonProperty(value = "updatedBy", access = JsonProperty.Access.WRITE_ONLY)
    private String updatedBy;

    /** Creates an instance of DenyAssignmentProperties class. */
    public DenyAssignmentProperties() {
    }

    /**
     * Get the denyAssignmentName property: The display name of the deny assignment.
     *
     * @return the denyAssignmentName value.
     */
    public String denyAssignmentName() {
        return this.denyAssignmentName;
    }

    /**
     * Set the denyAssignmentName property: The display name of the deny assignment.
     *
     * @param denyAssignmentName the denyAssignmentName value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withDenyAssignmentName(String denyAssignmentName) {
        this.denyAssignmentName = denyAssignmentName;
        return this;
    }

    /**
     * Get the description property: The description of the deny assignment.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of the deny assignment.
     *
     * @param description the description value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the permissions property: An array of permissions that are denied by the deny assignment.
     *
     * @return the permissions value.
     */
    public List<DenyAssignmentPermission> permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: An array of permissions that are denied by the deny assignment.
     *
     * @param permissions the permissions value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withPermissions(List<DenyAssignmentPermission> permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Get the scope property: The deny assignment scope.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The deny assignment scope.
     *
     * @param scope the scope value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the doNotApplyToChildScopes property: Determines if the deny assignment applies to child scopes. Default
     * value is false.
     *
     * @return the doNotApplyToChildScopes value.
     */
    public Boolean doNotApplyToChildScopes() {
        return this.doNotApplyToChildScopes;
    }

    /**
     * Set the doNotApplyToChildScopes property: Determines if the deny assignment applies to child scopes. Default
     * value is false.
     *
     * @param doNotApplyToChildScopes the doNotApplyToChildScopes value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withDoNotApplyToChildScopes(Boolean doNotApplyToChildScopes) {
        this.doNotApplyToChildScopes = doNotApplyToChildScopes;
        return this;
    }

    /**
     * Get the principals property: Array of principals to which the deny assignment applies.
     *
     * @return the principals value.
     */
    public List<Principal> principals() {
        return this.principals;
    }

    /**
     * Set the principals property: Array of principals to which the deny assignment applies.
     *
     * @param principals the principals value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withPrincipals(List<Principal> principals) {
        this.principals = principals;
        return this;
    }

    /**
     * Get the excludePrincipals property: Array of principals to which the deny assignment does not apply.
     *
     * @return the excludePrincipals value.
     */
    public List<Principal> excludePrincipals() {
        return this.excludePrincipals;
    }

    /**
     * Set the excludePrincipals property: Array of principals to which the deny assignment does not apply.
     *
     * @param excludePrincipals the excludePrincipals value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withExcludePrincipals(List<Principal> excludePrincipals) {
        this.excludePrincipals = excludePrincipals;
        return this;
    }

    /**
     * Get the isSystemProtected property: Specifies whether this deny assignment was created by Azure and cannot be
     * edited or deleted.
     *
     * @return the isSystemProtected value.
     */
    public Boolean isSystemProtected() {
        return this.isSystemProtected;
    }

    /**
     * Set the isSystemProtected property: Specifies whether this deny assignment was created by Azure and cannot be
     * edited or deleted.
     *
     * @param isSystemProtected the isSystemProtected value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withIsSystemProtected(Boolean isSystemProtected) {
        this.isSystemProtected = isSystemProtected;
        return this;
    }

    /**
     * Get the condition property: The conditions on the deny assignment. This limits the resources it can be assigned
     * to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     *
     * @return the condition value.
     */
    public String condition() {
        return this.condition;
    }

    /**
     * Set the condition property: The conditions on the deny assignment. This limits the resources it can be assigned
     * to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     *
     * @param condition the condition value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    /**
     * Get the conditionVersion property: Version of the condition.
     *
     * @return the conditionVersion value.
     */
    public String conditionVersion() {
        return this.conditionVersion;
    }

    /**
     * Set the conditionVersion property: Version of the condition.
     *
     * @param conditionVersion the conditionVersion value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    /**
     * Get the createdOn property: Time it was created.
     *
     * @return the createdOn value.
     */
    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    /**
     * Get the updatedOn property: Time it was updated.
     *
     * @return the updatedOn value.
     */
    public OffsetDateTime updatedOn() {
        return this.updatedOn;
    }

    /**
     * Get the createdBy property: Id of the user who created the assignment.
     *
     * @return the createdBy value.
     */
    public String createdBy() {
        return this.createdBy;
    }

    /**
     * Get the updatedBy property: Id of the user who updated the assignment.
     *
     * @return the updatedBy value.
     */
    public String updatedBy() {
        return this.updatedBy;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (permissions() != null) {
            permissions().forEach(e -> e.validate());
        }
        if (principals() != null) {
            principals().forEach(e -> e.validate());
        }
        if (excludePrincipals() != null) {
            excludePrincipals().forEach(e -> e.validate());
        }
    }
}
