// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * appRoleAssignment
 *
 * <p>Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public final class MicrosoftGraphAppRoleAssignment extends MicrosoftGraphDirectoryObjectInner {
    /*
     * The identifier (id) for the app role which is assigned to the principal. This app role must be exposed in the
     * appRoles property on the resource application's service principal (resourceId). If the resource application has
     * not declared any app roles, a default app role ID of 00000000-0000-0000-0000-000000000000 can be specified to
     * signal that the principal is assigned to the resource app without any specific app roles. Required on create.
     * Does not support $filter.
     */
    @JsonProperty(value = "appRoleId")
    private UUID appRoleId;

    /*
     * The createdDateTime property.
     */
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * The display name of the user, group, or service principal that was granted the app role assignment. Read-only.
     * Supports $filter (eq and startswith).
     */
    @JsonProperty(value = "principalDisplayName")
    private String principalDisplayName;

    /*
     * The unique identifier (id) for the user, group or service principal being granted the app role. Required on
     * create. Does not support $filter.
     */
    @JsonProperty(value = "principalId")
    private UUID principalId;

    /*
     * The type of the assigned principal. This can either be 'User', 'Group' or 'ServicePrincipal'. Read-only. Does
     * not support $filter.
     */
    @JsonProperty(value = "principalType")
    private String principalType;

    /*
     * The display name of the resource app's service principal to which the assignment is made. Does not support
     * $filter.
     */
    @JsonProperty(value = "resourceDisplayName")
    private String resourceDisplayName;

    /*
     * The unique identifier (id) for the resource service principal for which the assignment is made. Required on
     * create. Supports $filter (eq only).
     */
    @JsonProperty(value = "resourceId")
    private UUID resourceId;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphAppRoleAssignment class. */
    public MicrosoftGraphAppRoleAssignment() {
    }

    /**
     * Get the appRoleId property: The identifier (id) for the app role which is assigned to the principal. This app
     * role must be exposed in the appRoles property on the resource application's service principal (resourceId). If
     * the resource application has not declared any app roles, a default app role ID of
     * 00000000-0000-0000-0000-000000000000 can be specified to signal that the principal is assigned to the resource
     * app without any specific app roles. Required on create. Does not support $filter.
     *
     * @return the appRoleId value.
     */
    public UUID appRoleId() {
        return this.appRoleId;
    }

    /**
     * Set the appRoleId property: The identifier (id) for the app role which is assigned to the principal. This app
     * role must be exposed in the appRoles property on the resource application's service principal (resourceId). If
     * the resource application has not declared any app roles, a default app role ID of
     * 00000000-0000-0000-0000-000000000000 can be specified to signal that the principal is assigned to the resource
     * app without any specific app roles. Required on create. Does not support $filter.
     *
     * @param appRoleId the appRoleId value to set.
     * @return the MicrosoftGraphAppRoleAssignment object itself.
     */
    public MicrosoftGraphAppRoleAssignment withAppRoleId(UUID appRoleId) {
        this.appRoleId = appRoleId;
        return this;
    }

    /**
     * Get the createdDateTime property: The createdDateTime property.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: The createdDateTime property.
     *
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphAppRoleAssignment object itself.
     */
    public MicrosoftGraphAppRoleAssignment withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the principalDisplayName property: The display name of the user, group, or service principal that was granted
     * the app role assignment. Read-only. Supports $filter (eq and startswith).
     *
     * @return the principalDisplayName value.
     */
    public String principalDisplayName() {
        return this.principalDisplayName;
    }

    /**
     * Set the principalDisplayName property: The display name of the user, group, or service principal that was granted
     * the app role assignment. Read-only. Supports $filter (eq and startswith).
     *
     * @param principalDisplayName the principalDisplayName value to set.
     * @return the MicrosoftGraphAppRoleAssignment object itself.
     */
    public MicrosoftGraphAppRoleAssignment withPrincipalDisplayName(String principalDisplayName) {
        this.principalDisplayName = principalDisplayName;
        return this;
    }

    /**
     * Get the principalId property: The unique identifier (id) for the user, group or service principal being granted
     * the app role. Required on create. Does not support $filter.
     *
     * @return the principalId value.
     */
    public UUID principalId() {
        return this.principalId;
    }

    /**
     * Set the principalId property: The unique identifier (id) for the user, group or service principal being granted
     * the app role. Required on create. Does not support $filter.
     *
     * @param principalId the principalId value to set.
     * @return the MicrosoftGraphAppRoleAssignment object itself.
     */
    public MicrosoftGraphAppRoleAssignment withPrincipalId(UUID principalId) {
        this.principalId = principalId;
        return this;
    }

    /**
     * Get the principalType property: The type of the assigned principal. This can either be 'User', 'Group' or
     * 'ServicePrincipal'. Read-only. Does not support $filter.
     *
     * @return the principalType value.
     */
    public String principalType() {
        return this.principalType;
    }

    /**
     * Set the principalType property: The type of the assigned principal. This can either be 'User', 'Group' or
     * 'ServicePrincipal'. Read-only. Does not support $filter.
     *
     * @param principalType the principalType value to set.
     * @return the MicrosoftGraphAppRoleAssignment object itself.
     */
    public MicrosoftGraphAppRoleAssignment withPrincipalType(String principalType) {
        this.principalType = principalType;
        return this;
    }

    /**
     * Get the resourceDisplayName property: The display name of the resource app's service principal to which the
     * assignment is made. Does not support $filter.
     *
     * @return the resourceDisplayName value.
     */
    public String resourceDisplayName() {
        return this.resourceDisplayName;
    }

    /**
     * Set the resourceDisplayName property: The display name of the resource app's service principal to which the
     * assignment is made. Does not support $filter.
     *
     * @param resourceDisplayName the resourceDisplayName value to set.
     * @return the MicrosoftGraphAppRoleAssignment object itself.
     */
    public MicrosoftGraphAppRoleAssignment withResourceDisplayName(String resourceDisplayName) {
        this.resourceDisplayName = resourceDisplayName;
        return this;
    }

    /**
     * Get the resourceId property: The unique identifier (id) for the resource service principal for which the
     * assignment is made. Required on create. Supports $filter (eq only).
     *
     * @return the resourceId value.
     */
    public UUID resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The unique identifier (id) for the resource service principal for which the
     * assignment is made. Required on create. Supports $filter (eq only).
     *
     * @param resourceId the resourceId value to set.
     * @return the MicrosoftGraphAppRoleAssignment object itself.
     */
    public MicrosoftGraphAppRoleAssignment withResourceId(UUID resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAppRoleAssignment object itself.
     */
    public MicrosoftGraphAppRoleAssignment withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphAppRoleAssignment withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphAppRoleAssignment withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
