// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** informationalUrl. */
@Fluent
public final class MicrosoftGraphInformationalUrl {
    /*
     * CDN URL to the application's logo, Read-only.
     */
    @JsonProperty(value = "logoUrl")
    private String logoUrl;

    /*
     * Link to the application's marketing page. For example, https://www.contoso.com/app/marketing
     */
    @JsonProperty(value = "marketingUrl")
    private String marketingUrl;

    /*
     * Link to the application's privacy statement. For example, https://www.contoso.com/app/privacy
     */
    @JsonProperty(value = "privacyStatementUrl")
    private String privacyStatementUrl;

    /*
     * Link to the application's support page. For example, https://www.contoso.com/app/support
     */
    @JsonProperty(value = "supportUrl")
    private String supportUrl;

    /*
     * Link to the application's terms of service statement. For example, https://www.contoso.com/app/termsofservice
     */
    @JsonProperty(value = "termsOfServiceUrl")
    private String termsOfServiceUrl;

    /*
     * informationalUrl
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphInformationalUrl class. */
    public MicrosoftGraphInformationalUrl() {
    }

    /**
     * Get the logoUrl property: CDN URL to the application's logo, Read-only.
     *
     * @return the logoUrl value.
     */
    public String logoUrl() {
        return this.logoUrl;
    }

    /**
     * Set the logoUrl property: CDN URL to the application's logo, Read-only.
     *
     * @param logoUrl the logoUrl value to set.
     * @return the MicrosoftGraphInformationalUrl object itself.
     */
    public MicrosoftGraphInformationalUrl withLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    /**
     * Get the marketingUrl property: Link to the application's marketing page. For example,
     * https://www.contoso.com/app/marketing.
     *
     * @return the marketingUrl value.
     */
    public String marketingUrl() {
        return this.marketingUrl;
    }

    /**
     * Set the marketingUrl property: Link to the application's marketing page. For example,
     * https://www.contoso.com/app/marketing.
     *
     * @param marketingUrl the marketingUrl value to set.
     * @return the MicrosoftGraphInformationalUrl object itself.
     */
    public MicrosoftGraphInformationalUrl withMarketingUrl(String marketingUrl) {
        this.marketingUrl = marketingUrl;
        return this;
    }

    /**
     * Get the privacyStatementUrl property: Link to the application's privacy statement. For example,
     * https://www.contoso.com/app/privacy.
     *
     * @return the privacyStatementUrl value.
     */
    public String privacyStatementUrl() {
        return this.privacyStatementUrl;
    }

    /**
     * Set the privacyStatementUrl property: Link to the application's privacy statement. For example,
     * https://www.contoso.com/app/privacy.
     *
     * @param privacyStatementUrl the privacyStatementUrl value to set.
     * @return the MicrosoftGraphInformationalUrl object itself.
     */
    public MicrosoftGraphInformationalUrl withPrivacyStatementUrl(String privacyStatementUrl) {
        this.privacyStatementUrl = privacyStatementUrl;
        return this;
    }

    /**
     * Get the supportUrl property: Link to the application's support page. For example,
     * https://www.contoso.com/app/support.
     *
     * @return the supportUrl value.
     */
    public String supportUrl() {
        return this.supportUrl;
    }

    /**
     * Set the supportUrl property: Link to the application's support page. For example,
     * https://www.contoso.com/app/support.
     *
     * @param supportUrl the supportUrl value to set.
     * @return the MicrosoftGraphInformationalUrl object itself.
     */
    public MicrosoftGraphInformationalUrl withSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
        return this;
    }

    /**
     * Get the termsOfServiceUrl property: Link to the application's terms of service statement. For example,
     * https://www.contoso.com/app/termsofservice.
     *
     * @return the termsOfServiceUrl value.
     */
    public String termsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    /**
     * Set the termsOfServiceUrl property: Link to the application's terms of service statement. For example,
     * https://www.contoso.com/app/termsofservice.
     *
     * @param termsOfServiceUrl the termsOfServiceUrl value to set.
     * @return the MicrosoftGraphInformationalUrl object itself.
     */
    public MicrosoftGraphInformationalUrl withTermsOfServiceUrl(String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: informationalUrl.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: informationalUrl.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphInformationalUrl object itself.
     */
    public MicrosoftGraphInformationalUrl withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
