// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** onenoteEntityHierarchyModel. */
@Fluent
public class MicrosoftGraphOnenoteEntityHierarchyModel extends MicrosoftGraphOnenoteEntitySchemaObjectModel {
    /*
     * identitySet
     */
    @JsonProperty(value = "createdBy")
    private MicrosoftGraphIdentitySet createdBy;

    /*
     * The name of the notebook.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * identitySet
     */
    @JsonProperty(value = "lastModifiedBy")
    private MicrosoftGraphIdentitySet lastModifiedBy;

    /*
     * The date and time when the notebook was last modified. The timestamp represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Read-only.
     */
    @JsonProperty(value = "lastModifiedDateTime")
    private OffsetDateTime lastModifiedDateTime;

    /*
     * onenoteEntityHierarchyModel
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphOnenoteEntityHierarchyModel class. */
    public MicrosoftGraphOnenoteEntityHierarchyModel() {
    }

    /**
     * Get the createdBy property: identitySet.
     *
     * @return the createdBy value.
     */
    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: identitySet.
     *
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphOnenoteEntityHierarchyModel object itself.
     */
    public MicrosoftGraphOnenoteEntityHierarchyModel withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the displayName property: The name of the notebook.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the notebook.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphOnenoteEntityHierarchyModel object itself.
     */
    public MicrosoftGraphOnenoteEntityHierarchyModel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the lastModifiedBy property: identitySet.
     *
     * @return the lastModifiedBy value.
     */
    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set the lastModifiedBy property: identitySet.
     *
     * @param lastModifiedBy the lastModifiedBy value to set.
     * @return the MicrosoftGraphOnenoteEntityHierarchyModel object itself.
     */
    public MicrosoftGraphOnenoteEntityHierarchyModel withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: The date and time when the notebook was last modified. The timestamp
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Read-only.
     *
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: The date and time when the notebook was last modified. The timestamp
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Read-only.
     *
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphOnenoteEntityHierarchyModel object itself.
     */
    public MicrosoftGraphOnenoteEntityHierarchyModel withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: onenoteEntityHierarchyModel.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenoteEntityHierarchyModel.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenoteEntityHierarchyModel object itself.
     */
    public MicrosoftGraphOnenoteEntityHierarchyModel withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOnenoteEntityHierarchyModel withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOnenoteEntityHierarchyModel withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOnenoteEntityHierarchyModel withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (createdBy() != null) {
            createdBy().validate();
        }
        if (lastModifiedBy() != null) {
            lastModifiedBy().validate();
        }
    }
}
