// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** parentalControlSettings. */
@Fluent
public final class MicrosoftGraphParentalControlSettings {
    /*
     * Specifies the two-letter ISO country codes. Access to the application will be blocked for minors from the
     * countries specified in this list.
     */
    @JsonProperty(value = "countriesBlockedForMinors")
    private List<String> countriesBlockedForMinors;

    /*
     * Specifies the legal age group rule that applies to users of the app. Can be set to one of the following values:
     * ValueDescriptionAllowDefault. Enforces the legal minimum. This means parental consent is required for minors in
     * the European Union and Korea.RequireConsentForPrivacyServicesEnforces the user to specify date of birth to
     * comply with COPPA rules. RequireConsentForMinorsRequires parental consent for ages below 18, regardless of
     * country minor rules.RequireConsentForKidsRequires parental consent for ages below 14, regardless of country
     * minor rules.BlockMinorsBlocks minors from using the app.
     */
    @JsonProperty(value = "legalAgeGroupRule")
    private String legalAgeGroupRule;

    /*
     * parentalControlSettings
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphParentalControlSettings class. */
    public MicrosoftGraphParentalControlSettings() {
    }

    /**
     * Get the countriesBlockedForMinors property: Specifies the two-letter ISO country codes. Access to the application
     * will be blocked for minors from the countries specified in this list.
     *
     * @return the countriesBlockedForMinors value.
     */
    public List<String> countriesBlockedForMinors() {
        return this.countriesBlockedForMinors;
    }

    /**
     * Set the countriesBlockedForMinors property: Specifies the two-letter ISO country codes. Access to the application
     * will be blocked for minors from the countries specified in this list.
     *
     * @param countriesBlockedForMinors the countriesBlockedForMinors value to set.
     * @return the MicrosoftGraphParentalControlSettings object itself.
     */
    public MicrosoftGraphParentalControlSettings withCountriesBlockedForMinors(List<String> countriesBlockedForMinors) {
        this.countriesBlockedForMinors = countriesBlockedForMinors;
        return this;
    }

    /**
     * Get the legalAgeGroupRule property: Specifies the legal age group rule that applies to users of the app. Can be
     * set to one of the following values: ValueDescriptionAllowDefault. Enforces the legal minimum. This means parental
     * consent is required for minors in the European Union and Korea.RequireConsentForPrivacyServicesEnforces the user
     * to specify date of birth to comply with COPPA rules. RequireConsentForMinorsRequires parental consent for ages
     * below 18, regardless of country minor rules.RequireConsentForKidsRequires parental consent for ages below 14,
     * regardless of country minor rules.BlockMinorsBlocks minors from using the app.
     *
     * @return the legalAgeGroupRule value.
     */
    public String legalAgeGroupRule() {
        return this.legalAgeGroupRule;
    }

    /**
     * Set the legalAgeGroupRule property: Specifies the legal age group rule that applies to users of the app. Can be
     * set to one of the following values: ValueDescriptionAllowDefault. Enforces the legal minimum. This means parental
     * consent is required for minors in the European Union and Korea.RequireConsentForPrivacyServicesEnforces the user
     * to specify date of birth to comply with COPPA rules. RequireConsentForMinorsRequires parental consent for ages
     * below 18, regardless of country minor rules.RequireConsentForKidsRequires parental consent for ages below 14,
     * regardless of country minor rules.BlockMinorsBlocks minors from using the app.
     *
     * @param legalAgeGroupRule the legalAgeGroupRule value to set.
     * @return the MicrosoftGraphParentalControlSettings object itself.
     */
    public MicrosoftGraphParentalControlSettings withLegalAgeGroupRule(String legalAgeGroupRule) {
        this.legalAgeGroupRule = legalAgeGroupRule;
        return this;
    }

    /**
     * Get the additionalProperties property: parentalControlSettings.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: parentalControlSettings.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphParentalControlSettings object itself.
     */
    public MicrosoftGraphParentalControlSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
