// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** resourceVisualization. */
@Fluent
public final class MicrosoftGraphResourceVisualization {
    /*
     * A string describing where the item is stored. For example, the name of a SharePoint site or the user name
     * identifying the owner of the OneDrive storing the item.
     */
    @JsonProperty(value = "containerDisplayName")
    private String containerDisplayName;

    /*
     * Can be used for filtering by the type of container in which the file is stored. Such as Site or
     * OneDriveBusiness.
     */
    @JsonProperty(value = "containerType")
    private String containerType;

    /*
     * A path leading to the folder in which the item is stored.
     */
    @JsonProperty(value = "containerWebUrl")
    private String containerWebUrl;

    /*
     * The item's media type. Can be used for filtering for a specific type of file based on supported IANA Media Mime
     * Types. Note that not all Media Mime Types are supported.
     */
    @JsonProperty(value = "mediaType")
    private String mediaType;

    /*
     * A URL leading to the preview image for the item.
     */
    @JsonProperty(value = "previewImageUrl")
    private String previewImageUrl;

    /*
     * A preview text for the item.
     */
    @JsonProperty(value = "previewText")
    private String previewText;

    /*
     * The item's title text.
     */
    @JsonProperty(value = "title")
    private String title;

    /*
     * The item's media type. Can be used for filtering for a specific file based on a specific type. See below for
     * supported types.
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * resourceVisualization
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphResourceVisualization class. */
    public MicrosoftGraphResourceVisualization() {
    }

    /**
     * Get the containerDisplayName property: A string describing where the item is stored. For example, the name of a
     * SharePoint site or the user name identifying the owner of the OneDrive storing the item.
     *
     * @return the containerDisplayName value.
     */
    public String containerDisplayName() {
        return this.containerDisplayName;
    }

    /**
     * Set the containerDisplayName property: A string describing where the item is stored. For example, the name of a
     * SharePoint site or the user name identifying the owner of the OneDrive storing the item.
     *
     * @param containerDisplayName the containerDisplayName value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withContainerDisplayName(String containerDisplayName) {
        this.containerDisplayName = containerDisplayName;
        return this;
    }

    /**
     * Get the containerType property: Can be used for filtering by the type of container in which the file is stored.
     * Such as Site or OneDriveBusiness.
     *
     * @return the containerType value.
     */
    public String containerType() {
        return this.containerType;
    }

    /**
     * Set the containerType property: Can be used for filtering by the type of container in which the file is stored.
     * Such as Site or OneDriveBusiness.
     *
     * @param containerType the containerType value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withContainerType(String containerType) {
        this.containerType = containerType;
        return this;
    }

    /**
     * Get the containerWebUrl property: A path leading to the folder in which the item is stored.
     *
     * @return the containerWebUrl value.
     */
    public String containerWebUrl() {
        return this.containerWebUrl;
    }

    /**
     * Set the containerWebUrl property: A path leading to the folder in which the item is stored.
     *
     * @param containerWebUrl the containerWebUrl value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withContainerWebUrl(String containerWebUrl) {
        this.containerWebUrl = containerWebUrl;
        return this;
    }

    /**
     * Get the mediaType property: The item's media type. Can be used for filtering for a specific type of file based on
     * supported IANA Media Mime Types. Note that not all Media Mime Types are supported.
     *
     * @return the mediaType value.
     */
    public String mediaType() {
        return this.mediaType;
    }

    /**
     * Set the mediaType property: The item's media type. Can be used for filtering for a specific type of file based on
     * supported IANA Media Mime Types. Note that not all Media Mime Types are supported.
     *
     * @param mediaType the mediaType value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    /**
     * Get the previewImageUrl property: A URL leading to the preview image for the item.
     *
     * @return the previewImageUrl value.
     */
    public String previewImageUrl() {
        return this.previewImageUrl;
    }

    /**
     * Set the previewImageUrl property: A URL leading to the preview image for the item.
     *
     * @param previewImageUrl the previewImageUrl value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withPreviewImageUrl(String previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
        return this;
    }

    /**
     * Get the previewText property: A preview text for the item.
     *
     * @return the previewText value.
     */
    public String previewText() {
        return this.previewText;
    }

    /**
     * Set the previewText property: A preview text for the item.
     *
     * @param previewText the previewText value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withPreviewText(String previewText) {
        this.previewText = previewText;
        return this;
    }

    /**
     * Get the title property: The item's title text.
     *
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: The item's title text.
     *
     * @param title the title value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the type property: The item's media type. Can be used for filtering for a specific file based on a specific
     * type. See below for supported types.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The item's media type. Can be used for filtering for a specific file based on a specific
     * type. See below for supported types.
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: resourceVisualization.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: resourceVisualization.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
