// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.authorization.models.ProviderOperation;
import com.azure.resourcemanager.authorization.models.ResourceType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Provider Operations metadata. */
@Fluent
public final class ProviderOperationsMetadataInner {
    /*
     * The provider id.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The provider name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The provider type.
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * The provider display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The provider resource types
     */
    @JsonProperty(value = "resourceTypes")
    private List<ResourceType> resourceTypes;

    /*
     * The provider operations.
     */
    @JsonProperty(value = "operations")
    private List<ProviderOperation> operations;

    /** Creates an instance of ProviderOperationsMetadataInner class. */
    public ProviderOperationsMetadataInner() {
    }

    /**
     * Get the id property: The provider id.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The provider id.
     *
     * @param id the id value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The provider name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The provider name.
     *
     * @param name the name value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The provider type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The provider type.
     *
     * @param type the type value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the displayName property: The provider display name.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The provider display name.
     *
     * @param displayName the displayName value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the resourceTypes property: The provider resource types.
     *
     * @return the resourceTypes value.
     */
    public List<ResourceType> resourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Set the resourceTypes property: The provider resource types.
     *
     * @param resourceTypes the resourceTypes value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withResourceTypes(List<ResourceType> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    /**
     * Get the operations property: The provider operations.
     *
     * @return the operations value.
     */
    public List<ProviderOperation> operations() {
        return this.operations;
    }

    /**
     * Set the operations property: The provider operations.
     *
     * @param operations the operations value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withOperations(List<ProviderOperation> operations) {
        this.operations = operations;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceTypes() != null) {
            resourceTypes().forEach(e -> e.validate());
        }
        if (operations() != null) {
            operations().forEach(e -> e.validate());
        }
    }
}
