// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.MemberType;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Information about current or upcoming role eligibility schedule instance. */
@Fluent
public final class RoleEligibilityScheduleInstanceInner {
    /*
     * The role eligibility schedule instance ID.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The role eligibility schedule instance name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The role eligibility schedule instance type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * Role eligibility schedule instance properties.
     */
    @JsonProperty(value = "properties")
    private RoleEligibilityScheduleInstanceProperties innerProperties;

    /** Creates an instance of RoleEligibilityScheduleInstanceInner class. */
    public RoleEligibilityScheduleInstanceInner() {
    }

    /**
     * Get the id property: The role eligibility schedule instance ID.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The role eligibility schedule instance name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The role eligibility schedule instance type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Role eligibility schedule instance properties.
     *
     * @return the innerProperties value.
     */
    private RoleEligibilityScheduleInstanceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scope property: The role eligibility schedule scope.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: The role eligibility schedule scope.
     *
     * @param scope the scope value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the roleDefinitionId property: The role definition ID.
     *
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    /**
     * Set the roleDefinitionId property: The role definition ID.
     *
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    /**
     * Get the principalId property: The principal ID.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Set the principalId property: The principal ID.
     *
     * @param principalId the principalId value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    /**
     * Get the principalType property: The principal type of the assigned principal ID.
     *
     * @return the principalType value.
     */
    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    /**
     * Set the principalType property: The principal type of the assigned principal ID.
     *
     * @param principalType the principalType value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withPrincipalType(PrincipalType principalType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withPrincipalType(principalType);
        return this;
    }

    /**
     * Get the roleEligibilityScheduleId property: Id of the master role eligibility schedule.
     *
     * @return the roleEligibilityScheduleId value.
     */
    public String roleEligibilityScheduleId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleEligibilityScheduleId();
    }

    /**
     * Set the roleEligibilityScheduleId property: Id of the master role eligibility schedule.
     *
     * @param roleEligibilityScheduleId the roleEligibilityScheduleId value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withRoleEligibilityScheduleId(String roleEligibilityScheduleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withRoleEligibilityScheduleId(roleEligibilityScheduleId);
        return this;
    }

    /**
     * Get the status property: The status of the role eligibility schedule instance.
     *
     * @return the status value.
     */
    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: The status of the role eligibility schedule instance.
     *
     * @param status the status value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withStatus(Status status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the startDateTime property: The startDateTime of the role eligibility schedule instance.
     *
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startDateTime();
    }

    /**
     * Set the startDateTime property: The startDateTime of the role eligibility schedule instance.
     *
     * @param startDateTime the startDateTime value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withStartDateTime(OffsetDateTime startDateTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withStartDateTime(startDateTime);
        return this;
    }

    /**
     * Get the endDateTime property: The endDateTime of the role eligibility schedule instance.
     *
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endDateTime();
    }

    /**
     * Set the endDateTime property: The endDateTime of the role eligibility schedule instance.
     *
     * @param endDateTime the endDateTime value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withEndDateTime(OffsetDateTime endDateTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withEndDateTime(endDateTime);
        return this;
    }

    /**
     * Get the memberType property: Membership type of the role eligibility schedule.
     *
     * @return the memberType value.
     */
    public MemberType memberType() {
        return this.innerProperties() == null ? null : this.innerProperties().memberType();
    }

    /**
     * Set the memberType property: Membership type of the role eligibility schedule.
     *
     * @param memberType the memberType value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withMemberType(MemberType memberType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withMemberType(memberType);
        return this;
    }

    /**
     * Get the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     *
     * @return the condition value.
     */
    public String condition() {
        return this.innerProperties() == null ? null : this.innerProperties().condition();
    }

    /**
     * Set the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     *
     * @param condition the condition value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withCondition(String condition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withCondition(condition);
        return this;
    }

    /**
     * Get the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     *
     * @return the conditionVersion value.
     */
    public String conditionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().conditionVersion();
    }

    /**
     * Set the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     *
     * @param conditionVersion the conditionVersion value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withConditionVersion(String conditionVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withConditionVersion(conditionVersion);
        return this;
    }

    /**
     * Get the createdOn property: DateTime when role eligibility schedule was created.
     *
     * @return the createdOn value.
     */
    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    /**
     * Set the createdOn property: DateTime when role eligibility schedule was created.
     *
     * @param createdOn the createdOn value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withCreatedOn(OffsetDateTime createdOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withCreatedOn(createdOn);
        return this;
    }

    /**
     * Get the expandedProperties property: Additional properties of principal, scope and role definition.
     *
     * @return the expandedProperties value.
     */
    public ExpandedProperties expandedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().expandedProperties();
    }

    /**
     * Set the expandedProperties property: Additional properties of principal, scope and role definition.
     *
     * @param expandedProperties the expandedProperties value to set.
     * @return the RoleEligibilityScheduleInstanceInner object itself.
     */
    public RoleEligibilityScheduleInstanceInner withExpandedProperties(ExpandedProperties expandedProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleInstanceProperties();
        }
        this.innerProperties().withExpandedProperties(expandedProperties);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
