// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.DomainValidationProperties;
import com.azure.resourcemanager.cdn.models.DomainValidationState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g.
 * www.contoso.com.
 */
@Fluent
public final class AfdDomainInner extends ProxyResource {
    /*
     * The JSON object that contains the properties of the domain to create.
     */
    @JsonProperty(value = "properties")
    private AfdDomainProperties innerProperties;

    /**
     * Get the innerProperties property: The JSON object that contains the properties of the domain to create.
     *
     * @return the innerProperties value.
     */
    private AfdDomainProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the domainValidationState property: Provisioning substate shows the progress of custom HTTPS
     * enabling/disabling process step by step. DCV stands for DomainControlValidation.
     *
     * @return the domainValidationState value.
     */
    public DomainValidationState domainValidationState() {
        return this.innerProperties() == null ? null : this.innerProperties().domainValidationState();
    }

    /**
     * Get the hostname property: The host name of the domain. Must be a domain name.
     *
     * @return the hostname value.
     */
    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    /**
     * Set the hostname property: The host name of the domain. Must be a domain name.
     *
     * @param hostname the hostname value to set.
     * @return the AfdDomainInner object itself.
     */
    public AfdDomainInner withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdDomainProperties();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    /**
     * Get the validationProperties property: Values the customer needs to validate domain ownership.
     *
     * @return the validationProperties value.
     */
    public DomainValidationProperties validationProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().validationProperties();
    }

    /**
     * Get the provisioningState property: Provisioning status.
     *
     * @return the provisioningState value.
     */
    public AfdProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the deploymentStatus property: The deploymentStatus property.
     *
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentStatus();
    }

    /**
     * Get the profileName property: The name of the profile which holds the domain.
     *
     * @return the profileName value.
     */
    public String profileName() {
        return this.innerProperties() == null ? null : this.innerProperties().profileName();
    }

    /**
     * Get the tlsSettings property: The configuration specifying how to enable HTTPS for the domain - using
     * AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor
     * managed certificate by default.
     *
     * @return the tlsSettings value.
     */
    public AfdDomainHttpsParameters tlsSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().tlsSettings();
    }

    /**
     * Set the tlsSettings property: The configuration specifying how to enable HTTPS for the domain - using
     * AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor
     * managed certificate by default.
     *
     * @param tlsSettings the tlsSettings value to set.
     * @return the AfdDomainInner object itself.
     */
    public AfdDomainInner withTlsSettings(AfdDomainHttpsParameters tlsSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdDomainProperties();
        }
        this.innerProperties().withTlsSettings(tlsSettings);
        return this;
    }

    /**
     * Get the azureDnsZone property: Resource reference to the Azure DNS zone.
     *
     * @return the azureDnsZone value.
     */
    public ResourceReference azureDnsZone() {
        return this.innerProperties() == null ? null : this.innerProperties().azureDnsZone();
    }

    /**
     * Set the azureDnsZone property: Resource reference to the Azure DNS zone.
     *
     * @param azureDnsZone the azureDnsZone value to set.
     * @return the AfdDomainInner object itself.
     */
    public AfdDomainInner withAzureDnsZone(ResourceReference azureDnsZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdDomainProperties();
        }
        this.innerProperties().withAzureDnsZone(azureDnsZone);
        return this;
    }

    /**
     * Get the preValidatedCustomDomainResourceId property: Resource reference to the Azure resource where custom domain
     * ownership was prevalidated.
     *
     * @return the preValidatedCustomDomainResourceId value.
     */
    public ResourceReference preValidatedCustomDomainResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().preValidatedCustomDomainResourceId();
    }

    /**
     * Set the preValidatedCustomDomainResourceId property: Resource reference to the Azure resource where custom domain
     * ownership was prevalidated.
     *
     * @param preValidatedCustomDomainResourceId the preValidatedCustomDomainResourceId value to set.
     * @return the AfdDomainInner object itself.
     */
    public AfdDomainInner withPreValidatedCustomDomainResourceId(ResourceReference preValidatedCustomDomainResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdDomainProperties();
        }
        this.innerProperties().withPreValidatedCustomDomainResourceId(preValidatedCustomDomainResourceId);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
