// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.IpAddressGroup;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The JSON object that contains the properties required to create an edgenode. */
@Fluent
public final class EdgeNodeProperties {
    /*
     * List of ip address groups.
     */
    @JsonProperty(value = "ipAddressGroups", required = true)
    private List<IpAddressGroup> ipAddressGroups;

    /**
     * Get the ipAddressGroups property: List of ip address groups.
     *
     * @return the ipAddressGroups value.
     */
    public List<IpAddressGroup> ipAddressGroups() {
        return this.ipAddressGroups;
    }

    /**
     * Set the ipAddressGroups property: List of ip address groups.
     *
     * @param ipAddressGroups the ipAddressGroups value to set.
     * @return the EdgeNodeProperties object itself.
     */
    public EdgeNodeProperties withIpAddressGroups(List<IpAddressGroup> ipAddressGroups) {
        this.ipAddressGroups = ipAddressGroups;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipAddressGroups() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property ipAddressGroups in model EdgeNodeProperties"));
        } else {
            ipAddressGroups().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EdgeNodeProperties.class);
}
