// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.models.AfdStateProperties;
import com.azure.resourcemanager.cdn.models.SecurityPolicyPropertiesParameters;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The json object that contains properties required to create a security policy. */
@Fluent
public final class SecurityPolicyProperties extends AfdStateProperties {
    /*
     * The name of the profile which holds the security policy.
     */
    @JsonProperty(value = "profileName", access = JsonProperty.Access.WRITE_ONLY)
    private String profileName;

    /*
     * object which contains security policy parameters
     */
    @JsonProperty(value = "parameters")
    private SecurityPolicyPropertiesParameters parameters;

    /**
     * Get the profileName property: The name of the profile which holds the security policy.
     *
     * @return the profileName value.
     */
    public String profileName() {
        return this.profileName;
    }

    /**
     * Get the parameters property: object which contains security policy parameters.
     *
     * @return the parameters value.
     */
    public SecurityPolicyPropertiesParameters parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: object which contains security policy parameters.
     *
     * @param parameters the parameters value to set.
     * @return the SecurityPolicyProperties object itself.
     */
    public SecurityPolicyProperties withParameters(SecurityPolicyPropertiesParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (parameters() != null) {
            parameters().validate();
        }
    }
}
