// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.fluent.models.CustomDomainPropertiesParameters;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The customDomain JSON object required for custom domain creation or update. */
@Fluent
public final class CustomDomainParameters {
    /*
     * The JSON object that contains the properties of the custom domain to create.
     */
    @JsonProperty(value = "properties")
    private CustomDomainPropertiesParameters innerProperties;

    /**
     * Get the innerProperties property: The JSON object that contains the properties of the custom domain to create.
     *
     * @return the innerProperties value.
     */
    private CustomDomainPropertiesParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the hostname property: The host name of the custom domain. Must be a domain name.
     *
     * @return the hostname value.
     */
    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    /**
     * Set the hostname property: The host name of the custom domain. Must be a domain name.
     *
     * @param hostname the hostname value to set.
     * @return the CustomDomainParameters object itself.
     */
    public CustomDomainParameters withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomDomainPropertiesParameters();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
