// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.fluent.models.ProfilePropertiesUpdateParameters;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Properties required to update a profile. */
@Fluent
public final class ProfileUpdateParameters {
    /*
     * Profile tags
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * The JSON object containing profile update parameters.
     */
    @JsonProperty(value = "properties")
    private ProfilePropertiesUpdateParameters innerProperties;

    /**
     * Get the tags property: Profile tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Profile tags.
     *
     * @param tags the tags value to set.
     * @return the ProfileUpdateParameters object itself.
     */
    public ProfileUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: The JSON object containing profile update parameters.
     *
     * @return the innerProperties value.
     */
    private ProfilePropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     *
     * @return the originResponseTimeoutSeconds value.
     */
    public Integer originResponseTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().originResponseTimeoutSeconds();
    }

    /**
     * Set the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     *
     * @param originResponseTimeoutSeconds the originResponseTimeoutSeconds value to set.
     * @return the ProfileUpdateParameters object itself.
     */
    public ProfileUpdateParameters withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfilePropertiesUpdateParameters();
        }
        this.innerProperties().withOriginResponseTimeoutSeconds(originResponseTimeoutSeconds);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
