// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The JSON object that contains the properties to determine origin health using real requests/responses. */
@Fluent
public final class ResponseBasedOriginErrorDetectionParameters {
    /*
     * Type of response errors for real user requests for which origin will be deemed unhealthy
     */
    @JsonProperty(value = "responseBasedDetectedErrorTypes")
    private ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes;

    /*
     * The percentage of failed requests in the sample where failover should trigger.
     */
    @JsonProperty(value = "responseBasedFailoverThresholdPercentage")
    private Integer responseBasedFailoverThresholdPercentage;

    /*
     * The list of Http status code ranges that are considered as server errors for origin and it is marked as
     * unhealthy.
     */
    @JsonProperty(value = "httpErrorRanges")
    private List<HttpErrorRangeParameters> httpErrorRanges;

    /**
     * Get the responseBasedDetectedErrorTypes property: Type of response errors for real user requests for which origin
     * will be deemed unhealthy.
     *
     * @return the responseBasedDetectedErrorTypes value.
     */
    public ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes() {
        return this.responseBasedDetectedErrorTypes;
    }

    /**
     * Set the responseBasedDetectedErrorTypes property: Type of response errors for real user requests for which origin
     * will be deemed unhealthy.
     *
     * @param responseBasedDetectedErrorTypes the responseBasedDetectedErrorTypes value to set.
     * @return the ResponseBasedOriginErrorDetectionParameters object itself.
     */
    public ResponseBasedOriginErrorDetectionParameters withResponseBasedDetectedErrorTypes(
        ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes) {
        this.responseBasedDetectedErrorTypes = responseBasedDetectedErrorTypes;
        return this;
    }

    /**
     * Get the responseBasedFailoverThresholdPercentage property: The percentage of failed requests in the sample where
     * failover should trigger.
     *
     * @return the responseBasedFailoverThresholdPercentage value.
     */
    public Integer responseBasedFailoverThresholdPercentage() {
        return this.responseBasedFailoverThresholdPercentage;
    }

    /**
     * Set the responseBasedFailoverThresholdPercentage property: The percentage of failed requests in the sample where
     * failover should trigger.
     *
     * @param responseBasedFailoverThresholdPercentage the responseBasedFailoverThresholdPercentage value to set.
     * @return the ResponseBasedOriginErrorDetectionParameters object itself.
     */
    public ResponseBasedOriginErrorDetectionParameters withResponseBasedFailoverThresholdPercentage(
        Integer responseBasedFailoverThresholdPercentage) {
        this.responseBasedFailoverThresholdPercentage = responseBasedFailoverThresholdPercentage;
        return this;
    }

    /**
     * Get the httpErrorRanges property: The list of Http status code ranges that are considered as server errors for
     * origin and it is marked as unhealthy.
     *
     * @return the httpErrorRanges value.
     */
    public List<HttpErrorRangeParameters> httpErrorRanges() {
        return this.httpErrorRanges;
    }

    /**
     * Set the httpErrorRanges property: The list of Http status code ranges that are considered as server errors for
     * origin and it is marked as unhealthy.
     *
     * @param httpErrorRanges the httpErrorRanges value to set.
     * @return the ResponseBasedOriginErrorDetectionParameters object itself.
     */
    public ResponseBasedOriginErrorDetectionParameters withHttpErrorRanges(
        List<HttpErrorRangeParameters> httpErrorRanges) {
        this.httpErrorRanges = httpErrorRanges;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (httpErrorRanges() != null) {
            httpErrorRanges().forEach(e -> e.validate());
        }
    }
}
