// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.CapacityReservationGroupInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The List capacity reservation group with resource group response. */
@Fluent
public final class CapacityReservationGroupListResult {
    /*
     * The list of capacity reservation groups
     */
    @JsonProperty(value = "value", required = true)
    private List<CapacityReservationGroupInner> value;

    /*
     * The URI to fetch the next page of capacity reservation groups. Call ListNext() with this URI to fetch the next
     * page of capacity reservation groups.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of CapacityReservationGroupListResult class. */
    public CapacityReservationGroupListResult() {
    }

    /**
     * Get the value property: The list of capacity reservation groups.
     *
     * @return the value value.
     */
    public List<CapacityReservationGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of capacity reservation groups.
     *
     * @param value the value value to set.
     * @return the CapacityReservationGroupListResult object itself.
     */
    public CapacityReservationGroupListResult withValue(List<CapacityReservationGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of capacity reservation groups. Call ListNext() with
     * this URI to fetch the next page of capacity reservation groups.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of capacity reservation groups. Call ListNext() with
     * this URI to fetch the next page of capacity reservation groups.
     *
     * @param nextLink the nextLink value to set.
     * @return the CapacityReservationGroupListResult object itself.
     */
    public CapacityReservationGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property value in model CapacityReservationGroupListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CapacityReservationGroupListResult.class);
}
