// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** This is the safety profile of the Gallery Image Version. */
@Fluent
public final class GalleryImageVersionSafetyProfile extends GalleryArtifactSafetyProfileBase {
    /*
     * Indicates whether this image has been reported as violating Microsoft's policies.
     */
    @JsonProperty(value = "reportedForPolicyViolation", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean reportedForPolicyViolation;

    /*
     * A list of Policy Violations that have been reported for this Gallery Image Version.
     */
    @JsonProperty(value = "policyViolations", access = JsonProperty.Access.WRITE_ONLY)
    private List<PolicyViolation> policyViolations;

    /** Creates an instance of GalleryImageVersionSafetyProfile class. */
    public GalleryImageVersionSafetyProfile() {
    }

    /**
     * Get the reportedForPolicyViolation property: Indicates whether this image has been reported as violating
     * Microsoft's policies.
     *
     * @return the reportedForPolicyViolation value.
     */
    public Boolean reportedForPolicyViolation() {
        return this.reportedForPolicyViolation;
    }

    /**
     * Get the policyViolations property: A list of Policy Violations that have been reported for this Gallery Image
     * Version.
     *
     * @return the policyViolations value.
     */
    public List<PolicyViolation> policyViolations() {
        return this.policyViolations;
    }

    /** {@inheritDoc} */
    @Override
    public GalleryImageVersionSafetyProfile withAllowDeletionOfReplicatedLocations(
        Boolean allowDeletionOfReplicatedLocations) {
        super.withAllowDeletionOfReplicatedLocations(allowDeletionOfReplicatedLocations);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (policyViolations() != null) {
            policyViolations().forEach(e -> e.validate());
        }
    }
}
