/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.GalleryApplicationCustomAction;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class GalleryApplicationProperties {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="eula")
    private String eula;
    @JsonProperty(value="privacyStatementUri")
    private String privacyStatementUri;
    @JsonProperty(value="releaseNoteUri")
    private String releaseNoteUri;
    @JsonProperty(value="endOfLifeDate")
    private OffsetDateTime endOfLifeDate;
    @JsonProperty(value="supportedOSType", required=true)
    private OperatingSystemTypes supportedOSType;
    @JsonProperty(value="customActions")
    private List<GalleryApplicationCustomAction> customActions;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationProperties.class);

    public String description() {
        return this.description;
    }

    public GalleryApplicationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public GalleryApplicationProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public GalleryApplicationProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String releaseNoteUri() {
        return this.releaseNoteUri;
    }

    public GalleryApplicationProperties withReleaseNoteUri(String releaseNoteUri) {
        this.releaseNoteUri = releaseNoteUri;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public GalleryApplicationProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public OperatingSystemTypes supportedOSType() {
        return this.supportedOSType;
    }

    public GalleryApplicationProperties withSupportedOSType(OperatingSystemTypes supportedOSType) {
        this.supportedOSType = supportedOSType;
        return this;
    }

    public List<GalleryApplicationCustomAction> customActions() {
        return this.customActions;
    }

    public GalleryApplicationProperties withCustomActions(List<GalleryApplicationCustomAction> customActions) {
        this.customActions = customActions;
        return this;
    }

    public void validate() {
        if (this.supportedOSType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property supportedOSType in model GalleryApplicationProperties"));
        }
        if (this.customActions() != null) {
            this.customActions().forEach(e -> e.validate());
        }
    }
}

