// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Container group diagnostic information. */
@Fluent
public final class ContainerGroupDiagnostics {
    /*
     * Container group log analytics information.
     */
    @JsonProperty(value = "logAnalytics")
    private LogAnalytics logAnalytics;

    /**
     * Get the logAnalytics property: Container group log analytics information.
     *
     * @return the logAnalytics value.
     */
    public LogAnalytics logAnalytics() {
        return this.logAnalytics;
    }

    /**
     * Set the logAnalytics property: Container group log analytics information.
     *
     * @param logAnalytics the logAnalytics value to set.
     * @return the ContainerGroupDiagnostics object itself.
     */
    public ContainerGroupDiagnostics withLogAnalytics(LogAnalytics logAnalytics) {
        this.logAnalytics = logAnalytics;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (logAnalytics() != null) {
            logAnalytics().validate();
        }
    }
}
