// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DnsNameLabelReusePolicy. */
public final class DnsNameLabelReusePolicy extends ExpandableStringEnum<DnsNameLabelReusePolicy> {
    /** Static value Unsecure for DnsNameLabelReusePolicy. */
    public static final DnsNameLabelReusePolicy UNSECURE = fromString("Unsecure");

    /** Static value TenantReuse for DnsNameLabelReusePolicy. */
    public static final DnsNameLabelReusePolicy TENANT_REUSE = fromString("TenantReuse");

    /** Static value SubscriptionReuse for DnsNameLabelReusePolicy. */
    public static final DnsNameLabelReusePolicy SUBSCRIPTION_REUSE = fromString("SubscriptionReuse");

    /** Static value ResourceGroupReuse for DnsNameLabelReusePolicy. */
    public static final DnsNameLabelReusePolicy RESOURCE_GROUP_REUSE = fromString("ResourceGroupReuse");

    /** Static value Noreuse for DnsNameLabelReusePolicy. */
    public static final DnsNameLabelReusePolicy NOREUSE = fromString("Noreuse");

    /**
     * Creates or finds a DnsNameLabelReusePolicy from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DnsNameLabelReusePolicy.
     */
    @JsonCreator
    public static DnsNameLabelReusePolicy fromString(String name) {
        return fromString(name, DnsNameLabelReusePolicy.class);
    }

    /** @return known DnsNameLabelReusePolicy values. */
    public static Collection<DnsNameLabelReusePolicy> values() {
        return values(DnsNameLabelReusePolicy.class);
    }
}
