// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** A container group or container instance event. */
@Immutable
public final class Event {
    /*
     * The count of the event.
     */
    @JsonProperty(value = "count", access = JsonProperty.Access.WRITE_ONLY)
    private Integer count;

    /*
     * The date-time of the earliest logged event.
     */
    @JsonProperty(value = "firstTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime firstTimestamp;

    /*
     * The date-time of the latest logged event.
     */
    @JsonProperty(value = "lastTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastTimestamp;

    /*
     * The event name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The event message.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /*
     * The event type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the count property: The count of the event.
     *
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Get the firstTimestamp property: The date-time of the earliest logged event.
     *
     * @return the firstTimestamp value.
     */
    public OffsetDateTime firstTimestamp() {
        return this.firstTimestamp;
    }

    /**
     * Get the lastTimestamp property: The date-time of the latest logged event.
     *
     * @return the lastTimestamp value.
     */
    public OffsetDateTime lastTimestamp() {
        return this.lastTimestamp;
    }

    /**
     * Get the name property: The event name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the message property: The event message.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the type property: The event type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
